<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveActivity
{

	/**
	 * render frontend group activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param GroupTable                      $group
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $group, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type								=	( isset( $assetMatches[2] ) ? $assetMatches[2] : '' );
		$user								=	CBuser::getMyUserDataInstance();
		$groupOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );

		if ( CBGroupJive::canAccessGroup( $group, $user ) ) {
			$groupName						=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $group->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName						=	htmlspecialchars( CBTxt::T( $group->getString( 'name' ) ) );
		}

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $group, $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) );
			}

			switch ( $type ) {
				case 'join':
				case 'user_join':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'JOINED_YOUR_GROUP', 'joined your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'JOINED_GROUP', 'joined group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'user_cancel':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'CANCELLED_JOIN_YOUR_GROUP', 'cancelled request to join your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'CANCELLED_JOIN_GROUP', 'cancelled request to join group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'user_approve':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'AWAITING_APPROVAL_JOIN_YOUR_GROUP', 'awaiting approval to join your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'AWAITING_APPROVAL_JOIN_GROUP', 'awaiting approval to join group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'user_accepted':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'JOIN_YOUR_GROUP_ACCEPTED', 'request to join your group [group] accepted', array( '[group]' => $groupName ) );
					} elseif ( $user->getInt( 'user_id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
						$title				=	CBTxt::T( 'YOUR_JOIN_GROUP_ACCEPTED', 'accepted your request to join group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'JOIN_GROUP_ACCEPTED', 'request to join group [group] accepted', array( '[group]' => $groupName ) );
					}
					break;
				case 'user_rejected':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'JOIN_YOUR_GROUP_REJECTED', 'request to join your group [group] rejected', array( '[group]' => $groupName ) );
					} elseif ( $user->getInt( 'user_id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
						$title				=	CBTxt::T( 'YOUR_JOIN_GROUP_REJECTED', 'rejected your request to join group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'JOIN_GROUP_REJECTED', 'request to join group [group] rejected', array( '[group]' => $groupName ) );
					}
					break;
				case 'leave':
				case 'user_leave':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'LEFT_YOUR_GROUP', 'left your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'LEFT_GROUP', 'left group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'create':
					$title					=	CBTxt::T( 'CREATED_GROUP', 'created group [group]', array( '[group]' => $groupName ) );
					break;
				case 'group_approved':
					$title					=	CBTxt::T( 'CREATE_GROUP_APPROVED', 'request to create group [group] accepted', array( '[group]' => $groupName ) );
					break;
				case 'group_pending':
					$title					=	CBTxt::T( 'CREATE_GROUP_PENDING', 'request to create group [group] pending approval', array( '[group]' => $groupName ) );
					break;
				case 'invite':
				case 'user_invite':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'INVITED_TO_YOUR_GROUP', 'was invited to your group [group]', array( '[group]' => $groupName ) );
					} elseif ( $user->getInt( 'user_id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
						$title				=	CBTxt::T( 'INVITED_YOU_TO_GROUP', 'invited you to join group [group]', array( '[group]' => $groupName ) );

						if ( ( CBGroupJive::getGroupStatus( $user, $group ) === null ) && $group->getInt( '_invite_id', 0 ) ) {
							$row->set( 'link', null );

							$returnUrl		=	base64_encode( $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'notifications', 'stream' => $stream->id() ) ) );

							$date			.=	'<div class="notificationsButtonsGJInvite float-right">'
											.		'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="notificationsButton notificationsButtonAcceptGJInvite btn btn-sm btn-success">' . CBTxt::T( 'Accept Group Invite' ) . '</a>'
											.		' <a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="notificationsButton notificationsButtonRejectGJInvite btn btn-sm btn-danger">' . CBTxt::T( 'Reject Group Invite' ) . '</a>'
											.	'</div>';
						}
					} else {
						$title				=	CBTxt::T( 'INVITED_TO_GROUP', 'was invited to group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'invite_accept':
					if ( $user->getInt( 'user_id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
						$title				=	CBTxt::T( 'ACCEPTED_YOUR_INVITE_TO_GROUP', 'accepted your invite to group [group]', array( '[group]' => $groupName ) );
					} elseif ( $groupOwner ) {
						$title				=	CBTxt::T( 'ACCEPTED_INVITE_TO_YOUR_GROUP', 'accepted invite to your [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'ACCEPTED_INVITE_TO_GROUP', 'accepted invite to [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'invite_reject':
					if ( $user->getInt( 'user_id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
						$title				=	CBTxt::T( 'REJECTED_YOUR_INVITE_TO_GROUP', 'rejected your invite to group [group]', array( '[group]' => $groupName ) );
					} elseif ( $groupOwner ) {
						$title				=	CBTxt::T( 'REJECTED_INVITE_TO_YOUR_GROUP', 'rejected invite to your [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'REJECTED_INVITE_TO_GROUP', 'rejected invite to [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'message':
				case 'group_message':
					if ( $groupOwner ) {
						$title				=	CBTxt::T( 'MESSAGE_FROM_YOUR_GROUP', 'message from your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'MESSAGE_FROM_GROUP', 'message from group [group]', array( '[group]' => $groupName ) );
					}
					break;
				default:
					if ( $type === 'activity' ) {
						// Activity type has already had its title parsed so lets skip it here so we don't double parse:
						break;
					}

					if ( ! $title ) {
						$title				=	' <span class="fa fa-caret-right"></span> <strong>' . $groupName . '</strong>';
					} elseif ( $groupOwner ) {
						$title				=	CBTxt::T( 'TITLE_IN_YOUR_GROUP', '[title] in your group [group]', array( '[title]' => $title, '[group]' => $groupName ) );
					} else {
						$title				=	CBTxt::T( 'TITLE_IN_GROUP', '[title] in group [group]', array( '[title]' => $title, '[group]' => $groupName ) );
					}
					break;
			}
		} else {
			$viewingGroup					=	( $stream->getInt( 'groupjive.ingroup', 0 ) === $group->getInt( 'id', 0 ) );
			$showInsert						=	true;

			switch( $type ) {
				case 'join':
				case 'user_join':
					if ( $viewingGroup ) {
						$title				=	CBTxt::T( 'joined this group' );
					} else {
						$title				=	CBTxt::T( 'joined a group' );
					}
					break;
				case 'leave':
				case 'user_leave':
					$message				=	null;

					if ( $viewingGroup ) {
						$title				=	CBTxt::T( 'left this group' );
					} else {
						$title				=	CBTxt::T( 'left a group' );
					}
					break;
				case 'create':
					if ( $viewingGroup ) {
						$title				=	CBTxt::T( 'created this group' );
					} else {
						$title				=	CBTxt::T( 'created a group' );
					}
					break;
				case 'invite':
				case 'user_invite':
					if ( $viewingGroup ) {
						$title				=	CBTxt::T( 'was invited to this group' );
					} else {
						$title				=	CBTxt::T( 'was invited to a group' );
					}
					break;
				default:
					if ( ! $viewingGroup ) {
						if ( ! $title ) {
							$title			=	' <span class="fa fa-caret-right"></span> <strong>' . $groupName . '</strong>';
						} elseif ( $groupOwner ) {
							$title			=	CBTxt::T( 'TITLE_IN_YOUR_GROUP', '[title] in your group [group]', array( '[title]' => $title, '[group]' => $groupName ) );
						} else {
							$title			=	CBTxt::T( 'TITLE_IN_GROUP', '[title] in group [group]', array( '[title]' => $title, '[group]' => $groupName ) );
						}
					}

					$showInsert				=	false;
					break;
			}

			if ( ( ! $viewingGroup ) && $showInsert ) {
				initToolTip();

				$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
				$userStatus					=	CBGroupJive::getGroupStatus( $user, $group );
				$cssClass					=	$group->getString( 'css' );
				$returnUrl					=	base64_encode( $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'activity', 'stream' => $stream->id() ) ) );
				$buttons					=	array();

				if ( $isModerator && ( $group->getInt( 'published', 1 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
					$buttons[]				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-sm btn-sm-block btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Group' ) . '</a>';
				} elseif ( ( ! $groupOwner ) && ( $group->getInt( 'type', 0 ) !== 4 ) ) {
					if ( $userStatus === null ) {
						if ( $group->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="btn btn-sm btn-sm-block btn-light border gjButton gjButtonReject">' . CBTxt::T( 'Reject Group Invite' ) . '</button>';
						}

						if ( ( $group->getInt( 'type', 0 ) !== 5 ) || $group->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-sm btn-sm-block btn-success gjButton gjButtonJoin">' . ( $group->getInt( '_invite_id', 0 ) ? CBTxt::T( 'Accept Group Invite' ) : CBTxt::T( 'Join Group' ) ) . '</a>';
						}
					} elseif ( $userStatus === 0 ) {
						$buttons[]			=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel your pending join request to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $group->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="btn btn-sm btn-sm-block btn-light border gjButton gjButtonCancel">' . CBTxt::T( 'Cancel Group Join Request' ) . '</button>';
					}
				}

				$insert						=	'<div class="gjActivity gjActivity' . $group->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
											.		'<div class="position-relative no-overflow border cbCanvasLayout cbCanvasLayoutMd">'
											.			'<div class="position-relative bg-light cbCanvasLayoutTop">'
											.				'<div class="position-absolute cbCanvasLayoutBackground">'
											.					$group->canvas()
											.				'</div>'
											.			'</div>'
											.			'<div class="position-relative row no-gutters bg-white border-top cbCanvasLayoutBottom">'
											.				'<div class="col-4 col-sm-3">'
											.					'<div class="position-absolute cbPosCanvasPhoto cbCanvasLayoutPhoto">'
											.						$group->logo( false, true, true )
											.					'</div>'
											.				'</div>'
											.				'<div class="col-8 col-sm-9">'
											.					'<div class="p-2">'
											.						'<div class="row no-gutters">'
											.							'<div class="order-0 col cbCanvasLayoutTitle">';

				if ( CBGroupJive::canAccessGroup( $group, $user ) ) {
					$insert					.=								'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" class="text-large">' . htmlspecialchars( CBTxt::T( $group->getString( 'name' ) ) ) . '</a></strong>';
				} else {
					$insert					.=								'<strong class="text-primary text-large">' . htmlspecialchars( CBTxt::T( $group->getString( 'name' ) ) ) . '</strong>';
				}

				$insert						.=							'</div>';

				if ( $buttons ) {
					$insert					.=							'<div class="ml-0 ml-sm-1 mt-2 mt-sm-0 order-last order-sm-1 col-12 col-sm-auto cbCanvasLayoutButtons">'
											.								implode( ' ', $buttons )
											.							'</div>';
				}

				$insert						.=						'</div>'
											.						'<div class="mt-2 mt-sm-1 text-muted text-overflow text-small cbCanvasLayoutCounters">';

				if ( $group->getInt( 'category', 0 ) ) {
					$insert					.=							'<span class="cbCanvasLayoutCounter gjGroupIconCategory"><span class="fa-before fa-folder">'
											.								' <a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $group->getInt( 'category', 0 ) ) ) . '">' . CBTxt::T( $group->category()->getString( 'name' ) ) . '</a>'
											.							'</span></span>';
				}

				$insert						.=							'<span class="cbCanvasLayoutCounter gjGroupIconType"><span class="fa-before fa-globe"> ' . $group->type() . '</span></span>'
											.							( $group->getInt( 'type', 0 ) !== 4 ? '<span class="cbCanvasLayoutCounter gjGroupIconUsers"><span class="fa-before fa-user"> ' . CBTxt::T( 'GROUP_USERS_COUNT', '%%COUNT%% User|%%COUNT%% Users', array( '%%COUNT%%' => $group->getInt( '_users', 0 ) ) ) . '</span></span>' : null )
											.						'</div>'
											.					'</div>'
											.				'</div>';

				if ( $group->getString( 'description' ) ) {
					$insert					.=				'<div class="gjCanvasDescription gjGroupDescription">'
											.					cbTooltip( null, $group->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
											.				'</div>';
				}

				$insert						.=			'</div>'
											.		'</div>'
											.	'</div>';
			}
		}

		$_PLUGINS->trigger( 'gj_onAfterGroupActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $group, $plugin, $output ) );
	}
}