<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Table;

use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Notifications;
use CBLib\Application\Application;
use CBLib\Database\Table\Table;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CB\Database\Table\UserTable;

defined('CBLIB') or die();

class NotificationTable extends Table
{
	/** @var int  */
	public $id				=	null;
	/** @var int  */
	public $user_id			=	null;
	/** @var int  */
	public $user			=	null;
	/** @var string  */
	public $asset			=	null;
	/** @var string  */
	public $title			=	null;
	/** @var string  */
	public $message			=	null;
	/** @var string  */
	public $link			=	null;
	/** @var int  */
	public $system			=	null;
	/** @var int  */
	public $published		=	null;
	/** @var int  */
	public $pinned			=	null;
	/** @var string  */
	public $date			=	null;
	/** @var string  */
	public $params			=	null;

	/** @var Registry  */
	protected $_params		=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_activity_notifications';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getInt( 'user_id', 0 ) ) {
			$this->setError( CBTxt::T( 'Owner not specified!' ) );

			return false;
		}

		if ( ! $this->getInt( 'user', 0 ) ) {
			$this->setError( CBTxt::T( 'User not specified!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$new	=	( ! $this->getInt( 'id', 0 ) );
		$old	=	new self();

		if ( ! $this->getString( 'asset' ) ) {
			$this->set( 'asset', 'profile.' . $this->getInt( 'user', 0 ) );
		}

		$this->set( 'published', $this->getInt( 'published', 1 ) );
		$this->set( 'date', $this->getString( 'date', Application::Database()->getUtcDateTime() ) );

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeUpdateNotification', array( &$this, $old ) ), true ) ) {
				return false;
			}
		} elseif ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeCreateNotification', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'activity_onAfterUpdateNotification', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'activity_onAfterCreateNotification', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeDeleteNotification', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		$_PLUGINS->trigger( 'activity_onAfterDeleteNotification', array( $this ) );

		return true;
	}

	/**
	 * @return Registry
	 */
	public function params()
	{
		if ( ! ( $this->getRaw( '_params' ) instanceof Registry ) ) {
			$this->set( '_params', new Registry( $this->getRaw( 'params' ) ) );
		}

		return $this->getRaw( '_params' );
	}

	/**
	 * @return ParamsInterface
	 */
	public function attachments()
	{
		static $cache		=	array();

		$id					=	$this->getInt( 'id', 0 );

		if ( ! isset( $cache[$id] ) ) {
			$cache[$id]		=	CBActivity::prepareAttachments( $this->params()->subTree( 'links' ) );
		}

		return $cache[$id];
	}

	/**
	 * @return UserTable|ActivityTable|CommentTable|TagTable|FollowTable|LikeTable|NotificationTable|null
	 */
	public function source()
	{
		global $_PLUGINS;

		static $cache		=	array();

		$id					=	$this->getString( 'asset' );

		if ( ! isset( $cache[$id] ) ) {
			$source			=	CBActivity::getSource( $id );

			$_PLUGINS->trigger( 'activity_onNotificationSource', array( $this, &$source ) );

			$cache[$id]		=	$source;
		}

		return $cache[$id];
	}

	/**
	 * @param Notifications|null $stream
	 * @return bool
	 */
	public function isGlobal( $stream = null )
	{
		if ( CBActivity::findParamOverride( $this, 'global', true ) === false ) {
			return false;
		}

		if ( $stream && ( ! $stream->getBool( 'global', true ) ) ) {
			return false;
		}

		return $this->getBool( 'global', false );
	}

	/**
	 * @param Notifications|null $stream
	 * @return bool
	 */
	public function isPinned( $stream = null )
	{
		if ( $this->isHidden() ) {
			return false;
		}

		if ( CBActivity::findParamOverride( $this, 'pinned', true ) === false ) {
			return false;
		}

		if ( $stream && ( ! $stream->getBool( 'pinned', false ) ) ) {
			return false;
		}

		return $this->getBool( 'pinned', false );
	}

	/**
	 * @param Notifications|null $stream
	 * @return bool
	 */
	public function isRead( $stream = null )
	{
		if ( CBActivity::findParamOverride( $this, 'read', true ) === false ) {
			return true;
		}

		if ( $stream && ( $stream->getString( 'read' ) === null ) ) {
			return true;
		}

		return (bool) $this->getInt( '_read' );
	}

	/**
	 * @return bool
	 */
	public function isHidden()
	{
		return ( $this->getString( '_hidden_id' ) || $this->getString( '_hidden_user' ) || $this->getString( '_hidden_asset' ) );
	}

	/**
	 * @return string|null
	 */
	public function getLink()
	{
		$link		=	$this->getString( 'link' );

		if ( $link ) {
			$link	=	\CBuser::getInstance( $this->getInt( 'user_id', 0 ), false )->replaceUserVars( $link, false, false, null, false );
		}

		return $link;
	}
}