<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\PluginTable;

defined( '_JEXEC' ) or die;

class plgSystemcbautoactionsbot extends JPlugin
{

	public function onAfterInitialise()
	{
		// Catch any exceptions thrown as we don't want to accidently block Joomla if an auto action was configured wrong:
		try {
			$canEval						=	$this->canEval();
			$db								=	JFactory::getDBO();

			$query							=	"SELECT *"
											.	"\n FROM " . $db->quoteName( '#__comprofiler_plugin_autoactions' )
											.	"\n WHERE " . $db->quoteName( 'trigger' ) . " != ''"
											.	"\n AND " . $db->quoteName( 'published' ) . " = 1"
											.	"\n ORDER BY " . $db->quoteName( 'ordering' ) . " ASC";
			$db->setQuery( $query );
			$rows							=	$db->loadObjectList();

			foreach ( $rows as $row ) {
				$triggers					=	explode( '|*|', (string) $row->trigger );

				foreach ( $triggers as $trigger ) {
					$trigger				=	trim( htmlspecialchars( $trigger ) );

					if ( ( ! $trigger ) || in_array( $trigger, [ 'internalGeneral', 'internalUsers' ], true ) || ( strpos( $trigger, 'joomla_' ) === false ) ) {
						continue;
					}

					$params					=	new JRegistry( $row->params );
					$references				=	explode( '|*|', $params->get( 'references', '' ) );

					if ( $references && $canEval ) {
						foreach ( $references as $i => $v ) {
							$references[$i]	=	(int) $v;
						}

						// Prepare a list of variables to send to the anonymous function:
						$vars				=	[	1	=>	'$var1 = null',
													2	=>	'$var2 = null',
													3	=>	'$var3 = null',
													4	=>	'$var4 = null',
													5	=>	'$var5 = null',
													6	=>	'$var6 = null',
													7	=>	'$var7 = null',
													8	=>	'$var8 = null',
													9	=>	'$var9 = null',
													10	=>	'$var10 = null',
													11	=>	'$var11 = null',
													12	=>	'$var12 = null',
													13	=>	'$var13 = null',
													14	=>	'$var14 = null',
													15	=>	'$var15 = null'
												];

						// Change variables to references as needed:
						foreach ( $vars as $i => $var ) {
							if ( in_array( $i, $references, true ) ) {
								$vars[$i]	=	'&' . $var;
							}
						}

						$function			=	'$function = function( ' . implode( ', ', $vars ) . ' ) use ( $row, $trigger ) {'
											.		'if ( ! plgSystemcbautoactionsbot::loadCBAutoActions() ) {'
											.			'return null;'
											.		'}'
											.		'$action = new \CB\Plugin\AutoActions\Table\AutoActionTable();'
											.		'$action->bind( $row );'
											.		'if ( $var1 instanceof \Joomla\Event\Event ) {'
											.			'foreach ( $var1->getArguments() as $k => $arg ) {'
											.				'${"var" . ( $k + 1 )} = $arg;'
											.			'}'
											.		'}'
											.		'$variables = [ \'trigger\' => $trigger, \'loop_key\' => null, \'loop\' => null, \'var1\' => &$var1, \'var2\' => &$var2, \'var3\' => &$var3, \'var4\' => &$var4, \'var5\' => &$var5, \'var6\' => &$var6, \'var7\' => &$var7, \'var8\' => &$var8, \'var9\' => &$var9, \'var10\' => &$var10, \'var11\' => &$var11, \'var12\' => &$var12, \'var13\' => &$var13, \'var14\' => &$var14, \'var15\' => &$var15 ];'
											.		'return $action->runAction( $variables );'
											.	'};';

						eval( $function );
					} else {
						$function			=	static function( $var1 = null, $var2 = null, $var3 = null, $var4 = null, $var5 = null, $var6 = null, $var7 = null, $var8 = null, $var9 = null, $var10 = null, $var11 = null, $var12 = null, $var13 = null, $var14 = null, $var15 = null ) use ( $row, $trigger ) {
													if ( ! plgSystemcbautoactionsbot::loadCBAutoActions() ) {
														return null;
													}

													$action			=	new \CB\Plugin\AutoActions\Table\AutoActionTable();

													$action->bind( $row );

													if ( $var1 instanceof \Joomla\Event\Event ) {
														foreach ( $var1->getArguments() as $k => $arg ) {
															${"var" . ( $k + 1 )}	=	$arg;
														}
													}

													$variables		=	[	'trigger'	=>	$trigger,
																			'loop_key'	=>	null,
																			'loop'		=>	null,
																			'var1'		=>	&$var1,
																			'var2'		=>	&$var2,
																			'var3'		=>	&$var3,
																			'var4'		=>	&$var4,
																			'var5'		=>	&$var5,
																			'var6'		=>	&$var6,
																			'var7'		=>	&$var7,
																			'var8'		=>	&$var8,
																			'var9'		=>	&$var9,
																			'var10'		=>	&$var10,
																			'var11'		=>	&$var11,
																			'var12'		=>	&$var12,
																			'var13'		=>	&$var13,
																			'var14'		=>	&$var14,
																			'var15'		=>	&$var15
																		];

													return $action->runAction( $variables );
												};
					}

					JFactory::getApplication()->registerEvent( str_replace( 'joomla_', '', $trigger ), $function );
				}
			}
		} catch ( Exception $e ) {}
	}

	/**
	 * Loads in CB Auto Actions as minimally as possible to allow for Joomla event binding
	 *
	 * @return bool|PluginTable
	 */
	public static function loadCBAutoActions()
	{
		global $_PLUGINS;

		static $CB_loaded	=	0;
		static $cache		=	false;

		if ( ! $CB_loaded++ ) {
			if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
				return false;
			}

			include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

			cbimport( 'cb.plugins' );

			if ( ! $_PLUGINS->loadPluginGroup( 'user', 'cbautoactions' ) ) {
				return false;
			}

			$cache			=	$_PLUGINS->getLoadedPlugin( 'user', 'cbautoactions' );
		}

		return $cache;
	}

	/**
	 * Checks if eval is available
	 *
	 * @return bool
	 */
	private function canEval(): bool
	{
		static $cache					=	null;

		if ( $cache === null ) {
			$cache						=	true;

			if ( function_exists( 'ini_get' ) ) {
				$disabledFunctions		=	ini_get( 'disabled_functions' );

				if ( $disabledFunctions !== false ) {
					$cache				=	( ! in_array( 'eval', explode( ',', $disabledFunctions ), true ) );
				}

				if ( $cache ) {
					$evalDisabled		=	ini_get( 'suhosin.executor.disable_eval' );

					if ( ( $evalDisabled === true ) || ( $evalDisabled === 1 ) ) {
						$cache			=	false;
					}
				}
			}
		}

		return $cache;
	}
}