<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		moojla.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Moojla Model
 */
class MoojlaModelMoojla extends JModelList
{
	public function getIcons()
	{
		// load user for access menus
		$user = JFactory::getUser();
		// reset icon array
		$icons  = array();
		// view groups array
		$viewGroups = array(
			'main' => array('png.courses', 'png.courses.catid_qpo0O0oqp_com_moojla_po0O0oq_course', 'png.course_fields_mapper', 'png.user_maps', 'png.user_fields_map', 'png.course_group_maps', 'png.enrolments', 'png.tags', 'png.tag_instances', 'png.healthcheck', 'png.cohorts', 'png.languagetranslation')
		);
		// view access array
		$viewAccess = array(
			'healthcheck.submenu' => 'healthcheck.submenu',
			'healthcheck.dashboard_list' => 'healthcheck.dashboard_list',
			'languagetranslation.submenu' => 'languagetranslation.submenu',
			'languagetranslation.dashboard_list' => 'languagetranslation.dashboard_list',
			'courses.access' => 'course.access',
			'course.access' => 'course.access',
			'course.create' => 'course.create',
			'courses.submenu' => 'course.submenu',
			'courses.dashboard_list' => 'course.dashboard_list',
			'course_fields_mapper.access' => 'course_field_mapper.access',
			'course_field_mapper.access' => 'course_field_mapper.access',
			'course_fields_mapper.submenu' => 'course_field_mapper.submenu',
			'course_fields_mapper.dashboard_list' => 'course_field_mapper.dashboard_list',
			'user_maps.submenu' => 'user_map.submenu',
			'user_maps.dashboard_list' => 'user_map.dashboard_list',
			'user_fields_map.submenu' => 'user_field_map.submenu',
			'user_fields_map.dashboard_list' => 'user_field_map.dashboard_list',
			'course_group_maps.submenu' => 'course_group_map.submenu',
			'course_group_maps.dashboard_list' => 'course_group_map.dashboard_list',
			'enrolments.submenu' => 'enrolment.submenu',
			'enrolments.dashboard_list' => 'enrolment.dashboard_list',
			'tags.access' => 'tag.access',
			'tag.access' => 'tag.access',
			'tags.submenu' => 'tag.submenu',
			'tags.dashboard_list' => 'tag.dashboard_list',
			'tag_instances.access' => 'tag_instance.access',
			'tag_instance.access' => 'tag_instance.access',
			'tag_instances.submenu' => 'tag_instance.submenu',
			'tag_instances.dashboard_list' => 'tag_instance.dashboard_list',
			'cohorts.submenu' => 'cohort.submenu',
			'cohorts.dashboard_list' => 'cohort.dashboard_list');
		// loop over the $views
		foreach($viewGroups as $group => $views)
		{
			$i = 0;
			if (MoojlaHelper::checkArray($views))
			{
				foreach($views as $view)
				{
					$add = false;
					// external views (links)
					if (strpos($view,'||') !== false)
					{
						$dwd = explode('||', $view);
						if (count($dwd) == 3)
						{
							list($type, $name, $url) = $dwd;
							$viewName 	= $name;
							$alt 		= $name;
							$url 		= $url;
							$image 		= $name . '.' . $type;
							$name 		= 'COM_MOOJLA_DASHBOARD_' . MoojlaHelper::safeString($name,'U');
						}
					}
					// internal views
					elseif (strpos($view,'.') !== false)
					{
						$dwd = explode('.', $view);
						if (count($dwd) == 3)
						{
							list($type, $name, $action) = $dwd;
						}
						elseif (count($dwd) == 2)
						{
							list($type, $name) = $dwd;
							$action = false;
						}
						if ($action)
						{
							$viewName = $name;
							switch($action)
							{
								case 'add':
									$url	= 'index.php?option=com_moojla&view=' . $name . '&layout=edit';
									$image	= $name . '_' . $action.  '.' . $type;
									$alt	= $name . '&nbsp;' . $action;
									$name	= 'COM_MOOJLA_DASHBOARD_'.MoojlaHelper::safeString($name,'U').'_ADD';
									$add	= true;
								break;
								default:
									// check for new convention (more stable)
									if (strpos($action, '_qpo0O0oqp_') !== false)
									{
										list($action, $extension) = (array) explode('_qpo0O0oqp_', $action);
										$extension = str_replace('_po0O0oq_', '.', $extension);
									}
									else
									{
										$extension = 'com_moojla.' . $name;
									}
									$url	= 'index.php?option=com_categories&view=categories&extension=' . $extension;
									$image	= $name . '_' . $action . '.' . $type;
									$alt	= $viewName . '&nbsp;' . $action;
									$name	= 'COM_MOOJLA_DASHBOARD_' . MoojlaHelper::safeString($name,'U') . '_' . MoojlaHelper::safeString($action,'U');
								break;
							}
						}
						else
						{
							$viewName 	= $name;
							$alt 		= $name;
							$url 		= 'index.php?option=com_moojla&view=' . $name;
							$image 		= $name . '.' . $type;
							$name 		= 'COM_MOOJLA_DASHBOARD_' . MoojlaHelper::safeString($name,'U');
							$hover		= false;
						}
					}
					else
					{
						$viewName 	= $view;
						$alt 		= $view;
						$url 		= 'index.php?option=com_moojla&view=' . $view;
						$image 		= $view . '.png';
						$name 		= ucwords($view).'<br /><br />';
						$hover		= false;
					}
					// first make sure the view access is set
					if (MoojlaHelper::checkArray($viewAccess))
					{
						// setup some defaults
						$dashboard_add = false;
						$dashboard_list = false;
						$accessTo = '';
						$accessAdd = '';
						// access checking start
						$accessCreate = (isset($viewAccess[$viewName.'.create'])) ? MoojlaHelper::checkString($viewAccess[$viewName.'.create']):false;
						$accessAccess = (isset($viewAccess[$viewName.'.access'])) ? MoojlaHelper::checkString($viewAccess[$viewName.'.access']):false;
						// set main controllers
						$accessDashboard_add = (isset($viewAccess[$viewName.'.dashboard_add'])) ? MoojlaHelper::checkString($viewAccess[$viewName.'.dashboard_add']):false;
						$accessDashboard_list = (isset($viewAccess[$viewName.'.dashboard_list'])) ? MoojlaHelper::checkString($viewAccess[$viewName.'.dashboard_list']):false;
						// check for adding access
						if ($add && $accessCreate)
						{
							$accessAdd = $viewAccess[$viewName.'.create'];
						}
						elseif ($add)
						{
							$accessAdd = 'core.create';
						}
						// check if access to view is set
						if ($accessAccess)
						{
							$accessTo = $viewAccess[$viewName.'.access'];
						}
						// set main access controllers
						if ($accessDashboard_add)
						{
							$dashboard_add	= $user->authorise($viewAccess[$viewName.'.dashboard_add'], 'com_moojla');
						}
						if ($accessDashboard_list)
						{
							$dashboard_list = $user->authorise($viewAccess[$viewName.'.dashboard_list'], 'com_moojla');
						}
						if (MoojlaHelper::checkString($accessAdd) && MoojlaHelper::checkString($accessTo))
						{
							// check access
							if($user->authorise($accessAdd, 'com_moojla') && $user->authorise($accessTo, 'com_moojla') && $dashboard_add)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						elseif (MoojlaHelper::checkString($accessTo))
						{
							// check access
							if($user->authorise($accessTo, 'com_moojla') && $dashboard_list)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						elseif (MoojlaHelper::checkString($accessAdd))
						{
							// check access
							if($user->authorise($accessAdd, 'com_moojla') && $dashboard_add)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						else
						{
							$icons[$group][$i]			= new StdClass;
							$icons[$group][$i]->url 	= $url;
							$icons[$group][$i]->name 	= $name;
							$icons[$group][$i]->image 	= $image;
							$icons[$group][$i]->alt 	= $alt;
						}
					}
					else
					{
						$icons[$group][$i]			= new StdClass;
						$icons[$group][$i]->url 	= $url;
						$icons[$group][$i]->name 	= $name;
						$icons[$group][$i]->image 	= $image;
						$icons[$group][$i]->alt 	= $alt;
					}
					$i++;
				}
			}
			else
			{
					$icons[$group][$i] = false;
			}
		}
		return $icons;
	}
}
