<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view' );

class QuotesViewQuote extends JViewLegacy
{

	public $layout_type = "QUOTE" ;

  protected $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

	}

	function display($tpl = null)
	{
		//cridem el CSS
		$document	= JFactory::getDocument();

		//get the invoice
		$this->invoice			= $this->get('Data');
		$this->items			= $this->get('Items');
		$this->taxes			= $this->get('Taxes');
		$this->templates		= $this->get('TemplatesData');
		$this->status			= $this->get('Status');
		$this->payments			= $this->get('Payments');

		$this->params = JComponentHelper::getParams( 'com_invoices' );

		$isNew		= ($this->invoice->id < 1);

		$text = $isNew ? JText::_( 'NEW' ) : JText::_( 'EDIT' );
		$title = $isNew ? JText::_( 'QUOTE' ) : $this->invoice->to_name;

		JToolbarHelper::title(   $title . ': <small><small>[ ' . $text.' ]</small></small>','invoices' );

		JToolbarHelper::apply();
		JToolbarHelper::save();

		if ($isNew)  {
			JToolbarHelper::cancel();
		} else {

			JToolbarHelper::cancel( 'cancel', JText::_('CLOSE') );

		}

		if($this->input->getVar('layout') != "form"){
			$this->taxes			= $this->get('TaxesInvoice');
			$this->payments			= $this->get('PaymentsInvoice');
			$this->payments2			= $this->get('PaymentsInvoice2');
		}

		$this->template			= $this->get('Template');

		// JS
		JHtmlBehavior::framework();

		JHtml::_('jquery.framework');

		$document->addScript('components/com_invoices/assets/js/items.js');
		$document->addScript('components/com_invoices/assets/js/users.js');
		//http://isocra.com/2008/02/table-drag-and-drop-jquery-plugin/
		$document->addScript('components/com_invoices/assets/jquery.tablednd.js');

		$document->addScriptDeclaration('var currency_before = "'.$this->invoice->currency_before.'"; var currency_after = "'.$this->invoice->currency_after.'"; var numtaxes = '.count($taxes).';');

		$document->addScriptDeclaration('var yesword = "'.JText::_('JYES').'"; var noword = "'.JText::_('JNO').'"; ');

		$document->addScriptDeclaration('var default_tax = '.str_replace(",",".",$params->get('tax',0)).'; ');

		$document->addScriptDeclaration('var number_decimals = '.$params->get('decimals_editing',2).'; ');

		parent::display($tpl);
	}

	function storepdf($location)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'dompdf_config.inc.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php');

		$mainframe = JFactory::getApplication();

		$plantilla = 'email' ;

		$html = $this->loadTemplate($plantilla);

		$search = array("€", "¢", "£", "¤", "¥");
		$replace = array("&euro;", "&cent;", "&pound;", "&curren;", "&yen;");

		$html = str_replace($search, $replace, $html);

		$html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');

		$html = utf8_decode($html);

		$html = '<!DOCTYPE HTML>
				<html>
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<style>
				'.$this->template->styles.'
				</style>
				</head>
				<body>'
				. $html .
				'</body></html>';

		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		$dompdf->render();

		$pdf = $dompdf->output();

		return file_put_contents($location, $pdf);
	}

}
