<?php

/*------------------------------------------------------------------------
# com_finances - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 JoomlaContentStatistics.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.JoomlaContentStatistics.com
# Technical Support:  Forum - http://www.JoomlaContentStatistics.com/forum
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams( 'com_invoices' );

$sep = $params->get("csvsep",";");
$rowsep = "\n";

?><?php echo JText::_('INVOICE_NUM'); ?><?php echo $sep; ?><?php echo JText::_('RECIPIENT_NAME'); ?><?php echo $sep; ?><?php echo JText::_('COMPANY'); ?><?php echo $sep; ?><?php echo JText::_('COUNTRY'); ?><?php echo $sep; ?><?php echo JText::_('VATID'); ?><?php echo $sep; ?><?php echo JText::_('EMAIL'); ?><?php echo $sep; ?><?php echo JText::_('LINKED_TO_JOOMLA_USER'); ?><?php echo $sep; ?><?php echo JText::_('INVOICE_DATE'); ?><?php echo $sep; ?><?php echo JText::_('SUBTOTAL'); ?><?php echo $sep; ?><?php foreach($this->taxes as $tax){ ?><?php echo $tax->name; ?><?php echo $sep; ?><?php echo $tax->name; ?> (%)<?php echo $sep; ?><?php } ?><?php echo JText::_('TOTAL'); ?><?php echo $sep; ?><?php echo JText::_('STATUS'); ?><?php echo $rowsep; ?><?php

  for ($i = 0, $n = count( $this->items ); $i < $n; $i++) {
    $row = &$this->items[$i];

    if(is_object($row->computed)){
      $row->subtotal = $row->computed->subtotal;
      $row->subtotal_items = $row->computed->subtotal_items;
    }
    else{
      $row->subtotal =InvoicesHelper::get_subtotal($row->id);
      $row->subtotal_items = InvoicesHelper::get_subtotal_items($row->id);
    }

    if(is_object($row->computed)){
      $row->display_taxes = $row->computed->taxes;
    }
    else{
      $row->display_taxes = InvoicesHelper::get_display_taxes($row);
    }

    $row->total = $row->computed_total;

    $row->subtotal = $row->subtotal_items ;

    ?><?php echo $row->invoice_num; ?><?php echo $sep; ?><?php echo $row->to_name; ?><?php echo $sep; ?><?php echo $row->to_company; ?><?php echo $sep; ?><?php echo $row->to_country; ?><?php echo $sep; ?><?php echo $row->to_vatid; ?><?php echo $sep; ?><?php echo $row->to_email; ?><?php echo $sep; ?><?php echo $row->username; ?><?php echo $sep; ?><?php echo JHTML::_('date', $row->invoice_date, JText::_('DATE_FORMAT_LC3')); ?><?php echo $sep; ?><?php echo InvoicesHelper::format_simple($row->subtotal); ?><?php echo $sep; ?><?php

    foreach($this->taxes as $tax){

	    foreach($row->display_taxes as $itemtax){
  			if($itemtax->tax_id == $tax->id){
  				//we have to display it
  				echo InvoicesHelper::format_simple($itemtax->tax);
  				echo $sep;
  				if(isset($itemtax->tax_percentage)) $vat_percentage = (float) str_replace("%", "", $itemtax->tax_percentage);
  				else $vat_percentage = 0;

  				echo InvoicesHelper::format_simple($vat_percentage);
  				echo $sep;
  			}

  		}

  	}

    $status = $row->status ? $row->status : $row->computed_status;

?><?php echo InvoicesHelper::format_simple($row->total); ?><?php echo $sep; ?><?php echo JText::_($status); ?><?php echo $rowsep; ?><?php } ?>
