<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

?>

<div class="form-group">
  <label class="control-label col-md-3" for="publish"> <?php echo JText::_( 'PUBLISHED' ); ?> </label>
  <div class="controls col-md-9">
    <div id="sign_group" class=" btn-group" data-toggle="buttons">
    <label class="btn btn-default <?php if($this->invoice->publish) echo "active"; ?>" for="publish1"> <?php echo JText::_('JYES'); ?> <input class="radio_toggle" type="radio" <?php if($this->invoice->publish) echo "checked='checked'"; ?> value="1" name="publish" id="publish1" autocomplete="off" /></label>
    <label class="btn btn-default <?php if(!$this->invoice->publish) echo "active"; ?>" for="publish0"> <?php echo JText::_('JNO'); ?> <input class="radio_toggle" type="radio" <?php if(!$this->invoice->publish) echo "checked='checked'"; ?> value="0" name="publish" id="publish0" autocomplete="off" /></label>
    </div>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="start_publish_<?php echo $this->invoice->id; ?>"> <?php echo JText::_( 'START_PUBLISHING'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group" >
      <input  class="form-control " 
              type="text" 
              name="start_publish" 
              id="start_publish_<?php echo $this->invoice->id; ?>" 
              data-date-format="yyyy-mm-dd"
              value="<?php echo $this->invoice->start_publish;?>" 
              placeholder="<?php echo JText::_( 'START_PUBLISHING' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="start_publish_btn_<?php echo $this->invoice->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
</div>

<script type="text/javascript">

  jQuery('#start_publish_<?php echo $this->invoice->id; ?>').datepicker().on('changeDate', function(ev) {
    jQuery('#start_publish_<?php echo $this->invoice->id; ?>').datepicker('hide');
  });

  jQuery("#start_publish_btn_<?php echo $this->invoice->id; ?>").click(function() {
    jQuery('#start_publish_<?php echo $this->invoice->id; ?>').datepicker('show');
  });

</script>

<div class="form-group">
  <label class="control-label col-md-3" for="end_publish_<?php echo $this->invoice->id; ?>"> <?php echo JText::_( 'END_PUBLISHING'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group" >
      <input  class="form-control " 
              type="text" 
              name="end_publish" 
              id="end_publish_<?php echo $this->invoice->id; ?>" 
              data-date-format="yyyy-mm-dd"
              value="<?php echo $this->invoice->end_publish;?>" 
              placeholder="<?php echo JText::_( 'END_PUBLISHING' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="end_publish_btn_<?php echo $this->invoice->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
</div>

<script type="text/javascript">

  jQuery('#end_publish_<?php echo $this->invoice->id; ?>').datepicker().on('changeDate', function(ev) {
    jQuery('#end_publish_<?php echo $this->invoice->id; ?>').datepicker('hide');
  });

  jQuery("#end_publish_btn_<?php echo $this->invoice->id; ?>").click(function() {
    jQuery('#end_publish_<?php echo $this->invoice->id; ?>').datepicker('show');
  });

</script>

<hr />

<div class="form-group">
  <label class="control-label col-md-3" for="public_link"> <?php echo JText::_( $this->layout_type . '_PUBLIC_LINK'); ?> </label>
  <div class="controls col-md-9">
    <div class="input-group">
      <input onClick="this.select();" class="form-control " id="public_link" readonly type="text"  value="<?php echo InvoicesHelper::getInvoicePublicLink($this->invoice->id); ?>" />
      <span class="input-group-btn">
        <button class="btn btn-default" type="button" onClick="jQuery('#public_link').select();"><?php echo JText::_('COPY'); ?></button>
      </span>
    </div><!-- /input-group -->
    <input type="hidden" name="auth_code" value="<?php echo $this->invoice->auth_code; ?>" />
  </div>
  <span class="help-block col-md-offset-3 col-md-9"><?php echo JText::_('PUBLIC_LINK_EXPLANATION'); ?></span>
</div>
    