<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>

<div class="form-group">
  <label class="control-label col-md-3" for="recurrent1"> <?php echo JText::_( 'IS_RECURRENT' ); ?> </label>
  <div class="controls col-md-9">
    <div class="btn-group">
      <button type="button"
              class="btn"
              id="recurrent1"
              :class="{'btn-success active': invoice.is_recurrent, 'btn-default': !invoice.is_recurrent}"
              @click="toggleRecurrent(1)"><?php echo JText::_('JYES'); ?></button>
      <button type="button"
              class="btn"
              id="recurrent0"
              :class="{'btn-danger active': !invoice.is_recurrent, 'btn-default': invoice.is_recurrent}"
              @click="toggleRecurrent(0)"><?php echo JText::_('JNO'); ?></button>
    </div>
    <input  type="hidden"
            name="is_recurrent"
            :value="invoice.is_recurrent">
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="rec_nextdate_"> <?php echo JText::_( 'NEXT_RECURRENCY_DATE'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group" >
    <input  class="form-control "
            type="text"
            name="rec_nextdate"
            id="rec_nextdate_"
            data-date-format="yyyy-mm-dd"
            v-model="invoice.rec_nextdate"
            placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

    <span class="input-group-btn">
      <span class="btn btn-default" id="rec_nextdate_btn_"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
    </span>
    </div>
  </div>
  <span class="help-block col-md-offset-3 col-md-9"><?php echo JText::_('NEXT_RECURRENCY_DATE_EXPLANATION'); ?></span>
</div>

<div class="form-group">
  <label class="control-label col-md-3" > <?php echo JText::_( 'REPEAT_EVERY' ); ?> </label>
  <div class="controls col-md-6">
    <div class="row">
      <div class="col-xs-4">
        <select name="rec_day" id="rec_day" class="form-control" v-model="invoice.rec_day">
          <?php
          for ($i=0;$i < 31; $i++)  { ?>
            <option value="<?php echo $i; ?>"><?php echo $i ;?></option>
            <?php } ?>
          </select>
          <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_DAYS'); ?></span>
        </div>
        <div class="col-xs-4">
          <select name="rec_month" id="rec_month" class="form-control" v-model="invoice.rec_month">

            <?php
            for ($i=0;$i < 12; $i++)  { ?>
              <option value="<?php echo $i; ?>"><?php echo $i ;?></option>
              <?php } ?>
            </select>
            <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_MONTHS'); ?></span>
          </div>
          <div class="col-xs-4">
            <select name="rec_year" id="rec_year" class="form-control" v-model="invoice.rec_year">
            <?php
            for ($i=0;$i < 11; $i++)  { ?>
              <option value="<?php echo $i; ?>"><?php echo $i ;?></option>
              <?php } ?>
            </select>
            <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_YEARS'); ?></span>
            </div>
          </div>
        </div>

      </div>

      <div class="form-group">
        <label class="control-label col-md-3" for="recurrentemail1"> <?php echo JText::_( 'SEND_EMAIL_RECURRING' ); ?> </label>
        <div class="controls col-md-9">
          <div class="btn-group">
            <button type="button"
                    class="btn"
                    id="recurrentemail1"
                    :class="{'btn-success active': invoice.rec_email, 'btn-default': !invoice.rec_email}"
                    @click="toggleRecemail(1)"><?php echo JText::_('JYES'); ?></button>
            <button type="button"
                    class="btn"
                    id="recurrentemail0"
                    :class="{'btn-danger active': !invoice.rec_email, 'btn-default': invoice.rec_email}"
                    @click="toggleRecemail(0)"><?php echo JText::_('JNO'); ?></button>
          </div>
          <input  type="hidden"
                  name="rec_email"
                  :value="invoice.rec_email">
        </div>
      </div>
