<table class="table table-hover" v-if="contact.quotes.length">

  <tbody id="quotes-body">

    <thead>
      <tr>
        <th></th>
        <th><?php echo JText::_('QUOTE_NUM'); ?></th>
        <th class="hidden-xs"><?php echo JText::_('RECIPIENT_NAME'); ?></th>
        <th colspan="2" class=" hidden-xs"><?php echo JText::_('STATUS'); ?></th>
        <?php if($this->params->get('sourcecolumn')){ ?>
        <th class="hidden-xs"><?php echo JText::_('EXTERNAL_TYPE'); ?></th>
        <?php } ?>
        <th class="hidden-xs text-right"><?php echo JText::_('SUBTOTAL'); ?></th>

        <th class="hidden-xs text-right"
            v-for="thetax in $root.alltaxes"
            v-show="$root.display_tax(thetax.id)"> {{ thetax.name }}</th>

        <th class=" text-right "><?php echo JText::_('TOTAL'); ?></th>
        <th></th>
        <?php if(InvoicesHelper::pdf_enabled()){?>
        <th class="hidden-xs"></th>
        <?php } ?>

      </tr>
    </thead>

    <tr
      v-for="invoice in contact.quotes"
      is="invoice"
      :invoice="invoice"
      :id="'row' + invoice.id"
      :data-value="invoice.amount"
      class='item-row'
      :extended="false"
    >
    </tr>

  </tbody>

</table>

<div class="muted center" v-else>
  <?php echo JText::_('NO_QUOTES_FOR_CONTACT'); ?>
  <br /><br />

  <a  :href="'index.php?option=com_invoices&controller=quotes&do=new_invoice&from=' + contact.id"
      class="btn btn-primary"
      title="<?php echo JText::_('CREATE_QUOTE_FOR_CONTACT');?>">
      <?php echo JText::_('CREATE_QUOTE_FOR_CONTACT');?>
  </a>
</div>
