<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport('joomla.application.component.model');

class QuotesModelQuote extends JModelLegacy
{

	var $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

		$array = $this->input->get('cid',  0, '', 'array');
		$this->setId((int)$array[0]);

		$this->params = JComponentHelper::getParams( 'com_invoices' );

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;

	}

	function &getData()
	{
		// Load the data

		$query = ' SELECT i.*, co.name as contact_name, u.username, co.user_id AS joomla_user_id FROM #__invoices_invoices as i '.
				' LEFT JOIN #__invoices_contacts AS co ON co.id = i.user_id '.
				' LEFT JOIN #__users AS u ON u.id = co.user_id '.
				'  WHERE i.id = '.$this->_id;
		$this->_db->setQuery( $query );
		$this->_data = $this->_db->loadObject();

		if(!empty($this->_data)) $this->_data->vincular_cliente_checkbox = 1;

		if (!$this->_data) {
			$this->_data = new stdClass();
			$this->_data->id = 0;

			$this->_data->from_name = $this->params->get('from_name');
			$this->_data->from_address = $this->params->get('from_address');
			$this->_data->from_num = $this->params->get('from_num');
			$this->_data->from_url = $this->params->get('from_url');
			$this->_data->from_phone = $this->params->get('from_phone');
			$this->_data->from_email = $this->params->get('from_email');
			$this->_data->currency_before = $this->params->get('currency_before');
			$this->_data->currency_after = $this->params->get('currency_after');

			$this->_data->taxes = "";
			$this->_data->to_name = "";
			$this->_data->to_company = "";
			$this->_data->to_address = "";
			$this->_data->to_zipcode = "";
			$this->_data->to_city = "";
			$this->_data->to_country = "";
			$this->_data->to_state = "";
			$this->_data->to_email = "";
			$this->_data->to_phone = "";
			$this->_data->to_vatid = "";
			$this->_data->contact_name = "";
			$this->_data->user_id = 0;
			$this->_data->template_id = $this->params->get('quote_template', 0);

			$this->_data->username = "";
			$this->_data->joomla_user_id = "";

			$this->_data->start_publish = "";
			$this->_data->end_publish = "";
			$this->_data->notes = "";
			$this->_data->admin_notes = "";

			$this->_data->discount = "";

			$this->_data->publish = 1;
			$this->_data->status = "";

			$this->_data->is_recurrent = 0;
			$this->_data->rec_nextdate = "";
			$this->_data->rec_year = 0;
			$this->_data->rec_month = 0;
			$this->_data->rec_day = 0;
			$this->_data->rec_email = 0;

			$this->_data->auth_code = "";

			$this->_data->vincular_cliente_checkbox = 2;

			$query = 	' SELECT i.real_invoice_num FROM #__invoices_invoices as i WHERE type = 2 '.
					 			' ORDER BY i.id DESC ';
			$this->_db->setQuery( $query );
			$this->_data->real_invoice_num = $this->_db->loadResult() + 1;
			$this->_data->invoice_num = InvoicesHelper::getInvoiceNum($this->_data->real_invoice_num, 2) ;

			$this->_data->invoice_date = date("Y-m-d");

			$this->_data->invoice_duedate = "";

			$this->_data->language = $this->params->get('default_language');

      $this->_data->rec_email = false;

			$from_id = $this->input->getInt('from') ;
			if($from_id){
				$query = ' SELECT co.*, u.username FROM #__invoices_contacts as co '.
								 ' LEFT JOIN #__users AS u ON u.id = co.user_id '.
								 ' WHERE co.id = '.$from_id;
				$this->_db->setQuery( $query );
				$from = $this->_db->loadObject();

				$this->_data->to_name = $from->name;
				$this->_data->to_address = $from->address;
				$this->_data->to_company = $from->company;
				$this->_data->to_email = $from->email;

				$this->_data->to_country = $from->country;
				$this->_data->to_state = $from->state;
				$this->_data->to_city = $from->city;
				$this->_data->to_zipcode = $from->zipcode;
				$this->_data->to_vatid = $from->vatid;
				$this->_data->to_phone = $from->phone;

				$this->_data->user_id = $from_id;
				$this->_data->contact_name = $from->name;
				$this->_data->vincular_cliente_checkbox = 1;

				$this->_data->username = $from->username;
				$this->_data->joomla_user_id = $from->user_id;
			}

			$query = 	' SELECT id '.
								' FROM #__invoices_taxes '.
								' WHERE checked = 1 '.
								' ORDER BY ordering, name '
								;
			$this->_db->setQuery( $query );
			$this->_data->taxes = $this->_db->loadColumn();

			$this->_data->taxes = implode(",", $this->_data->taxes);

			$this->_data->external_type = "";
			$this->_data->external_id = "";
			$this->_data->external_ref = "";

		}
		else{
			$this->_data->vincular_cliente_checkbox = 0;
		}

		$this->_data->taxes = explode(",", $this->_data->taxes);

		$this->_data->invoice_date = str_replace(" 00:00:00", "", $this->_data->invoice_date);
		$this->_data->invoice_duedate = str_replace(" 00:00:00", "", $this->_data->invoice_duedate);

		$this->_data->start_publish = str_replace(" 00:00:00", "", $this->_data->start_publish);
		$this->_data->end_publish = str_replace(" 00:00:00", "", $this->_data->end_publish);
		$this->_data->rec_nextdate = str_replace(" 00:00:00", "", $this->_data->rec_nextdate);

		if($this->_data->invoice_date == "0000-00-00") $this->_data->invoice_date = "";
		if($this->_data->invoice_duedate == "0000-00-00") $this->_data->invoice_duedate = "";
		if($this->_data->start_publish == "0000-00-00") $this->_data->start_publish = "";
		if($this->_data->end_publish == "0000-00-00") $this->_data->end_publish = "";
		if($this->_data->rec_nextdate == "0000-00-00") $this->_data->rec_nextdate = "";

		$this->_data->edit_link 	= JRoute::_('index.php?option=com_invoices&controller=invoice&tmpl=component&task=edit&cid[]=' . $this->_data->id . '&layout=form&modal=1' , false);

		$this->_data->pdf_link 	= InvoicesHelper::download_pdf_link($this->_data->id);

		$this->_data->public_link 		= InvoicesHelper::getInvoicePublicLink($this->_data->id) ;

		$this->_data->items = $this->getItems();

		$this->_data->payments = $this->getPayments();

		$this->_data->taxes = $this->getTaxes();

		$this->_data->type = 2;

		return $this->_data;
	}

	function getItems(){
		$this->items = array();
		if ($this->_id){
			$query = 	' SELECT it.*, tax.name AS tax_name FROM #__invoices_items AS it '.
						' LEFT JOIN #__invoices_taxes AS tax ON tax.id = it.tax_id '.
						' WHERE it.invoice_id = ' . $this->_id .
						' ORDER BY it.ordering ';
			$this->_db->setQuery( $query );
			$this->items = $this->_db->loadObjectList();

		}

		return $this->items;

	}

	function getPayments(){
		$this->payments = array();
		if (empty( $this->payments ) && $this->_id){
			$query = 	' SELECT * FROM #__invoices_payments '.
						' WHERE invoice_id = ' . $this->_id .
						' ORDER BY ordering ';
			$this->_db->setQuery( $query );
			$this->payments = $this->_db->loadObjectList();

		}

		return $this->payments;

	}

	function getPaymentsInvoice()
	{

		$query = 	' SELECT pa.* '.
					' FROM #__invoices_payments as pa '.
					' WHERE pa.invoice_id = ' . $this->_id .
					' AND pa.payment_status = 1 '.
					' ORDER BY ordering ';
					;
		$this->_db->setQuery( $query );
		$this->payments_invoice = $this->_db->loadObjectList();

		return $this->payments_invoice;
	}

	function getPaymentsInvoice2()
	{

		$query = 	' SELECT pa.* '.
					' FROM #__invoices_payments as pa '.
					' WHERE pa.invoice_id = ' . $this->_id .
					' AND pa.payment_status = 0 '.
					' ORDER BY ordering ';
					;
		$this->_db->setQuery( $query );
		$this->payments_invoice2 = $this->_db->loadObjectList();

		return $this->payments_invoice2;
	}

	function getTaxes(){

		if (empty( $this->taxes )){
			if($this->_id){ //is not new
				$query = 	' SELECT tax.*, tai.value AS tax_value, tai.active FROM #__invoices_taxes AS tax '
							.' LEFT JOIN #__invoices_tax_invoice AS tai ON (tai.tax_id = tax.id AND tai.reference_id = ' . $this->_id . ' AND tai.type = 1) '
							.' ORDER BY ordering, name ';
			}
			else{ //is new
				$query = 	' SELECT tax.*, tax.value AS tax_value, tax.checked AS active FROM #__invoices_taxes AS tax '
							.' ORDER BY ordering, name ';
			}
			$this->_db->setQuery( $query );
			$this->taxes = $this->_db->loadObjectList('id');

		}

		return $this->taxes;

	}

	function getTaxesInvoice(){

		$query = ' SELECT tax.*, tai.value AS value '
				.' FROM #__invoices_taxes AS tax '
				.' LEFT JOIN #__invoices_tax_invoice AS tai ON (tai.tax_id = tax.id AND tai.reference_id = ' . $this->_data->id . ' AND tai.type = 1) '
				.' WHERE tai.active = 1 '
				.' ORDER BY ordering, name ' ;
		$this->_db->setQuery( $query );
		$this->taxes = $this->_db->loadObjectList();

		return $this->taxes;
	}

	function getStatus(){

		if (empty( $this->status )){
			$this->status = InvoicesHelper::getQuoteStatus();

		}

		return $this->status;

	}

	function getTemplatesData()
		{
			// Lets load the data if it doesn't already exist
			if (empty( $this->_templates_data )){
				$query = ' SELECT * FROM #__invoices_templates '.
						 ' ORDER BY name ';
				$this->_db->setQuery( $query );
				$this->_templates_data = $this->_db->loadObjectList();
			}

		return $this->_templates_data;

	}

	function &getTemplate()
	{

		$query = 	' SELECT te.* '.
					' FROM #__invoices_templates as te '.
					' WHERE te.id = ' . $this->_data->template_id
					;
		$this->_db->setQuery( $query );
		$this->template = $this->_db->loadObject();

		return $this->template;
	}

}
