<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.model' );

class CurrenciesModelCurrencies extends JModelLegacy
{

	var $_data;
	var $_total = null;
	var $_pagination = null;
	var $_keywords = null;

	var $input;

	function __construct(){
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('invoices.currencies.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = $mainframe->getUserStateFromRequest('invoices.currencies.limitstart', 'limitstart', 0, 'int');
		$keywords = trim($mainframe->getUserStateFromRequest('invoices.currencies.keywords','keywords','','string'));
		$filter_order     = $mainframe->getUserStateFromRequest('invoices.currencies.filter_order', 'filter_order', 'id', 'cmd' );
    $filter_order_Dir = $mainframe->getUserStateFromRequest('invoices.currencies.filter_order_Dir', 'filter_order_Dir', 'ASC', 'word' );

		$this->setState('filter_order', $filter_order);
    $this->setState('filter_order_Dir', $filter_order_Dir);
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->setState('keywords', $keywords);

  }


	function getTotal()
  {
 	// Load the content if it doesn't already exist
 	if (empty($this->_total)) {
 	    $query = $this->_buildQuery();
 	    $this->_total = $this->_getListCount($query);
 	}
 	return $this->_total;
  }

 function getPagination()
  {
 	// Load the content if it doesn't already exist
 	if (empty($this->_pagination)) {
 	    jimport('joomla.html.pagination');
 	    $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
 	}
 	return $this->_pagination;
  }


	function getKeywords(){
		if (empty($this->_keywords)) {
			$this->_keywords = $this->getState('keywords')	;
		}
		return $this->_keywords;
	}


	function getFilterOrder(){
		return  $this->getState('filter_order') ;
  }
  function getFilterOrderDir(){
		return  $this->getState('filter_order_Dir') ;
  }

  function _buildContentOrderBy()
	{

			$filter_order     = $this->getState('filter_order' ) ;
			$filter_order_Dir = $this->getState('filter_order_Dir') ;

			$orderby = ' ORDER BY '.$filter_order.' '.$filter_order_Dir . ' ';

			return $orderby;
	}

	function _buildQuery()
	{

		$keywords = $this->getKeywords();


		$where_clause = array();

		if ($keywords != ""){
			$where_clause[] = ' ( currency_name LIKE "%'.$keywords.'%" OR currency_code LIKE "%'.$keywords.'%" OR currency_symbol LIKE "%'.$keywords.'%") ';
		}


		$orderby = $this->_buildContentOrderBy();

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT * '
						.' FROM #__invoices_currencies'
						.$where_clause
						.$orderby
		;

		return $query;
	}

	function getData(){

		if (empty( $this->_data )){
			$query = $this->_buildQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));

		}

 	return $this->_data;

	}

}
