<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSL\Utils\Html as HtmlUtils;

$rootUri = Uri::root();

if (HelpdeskproHelper::isJoomla4())
{
	$tabApiPrefix = 'uitab.';
}
else
{
	$tabApiPrefix = 'bootstrap.';
}

echo HTMLHelper::_($tabApiPrefix . 'addTab', 'field', 'translation-page', Text::_('HDP_TRANSLATION', true));
echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'field-translation', array('active' => 'translation-page-'.$this->languages[0]->sef));

foreach ($this->languages as $language)
{
	$sef = $language->sef;
	echo HTMLHelper::_($tabApiPrefix . 'addTab', 'field-translation', 'translation-page-' . $sef, $language->title . ' <img src="' . $rootUri . 'media/com_helpdeskpro/assets/flags/' . $sef . '.png" />');
	?>
        <div class="control-group">
            <div class="control-label">
				<?php echo Text::_('HDP_TITLE'); ?>
            </div>
            <div class="controls">
                <input class="input-xlarge form-control" type="text" name="title_<?php echo $sef; ?>" id="title_<?php echo $sef; ?>" maxlength="250" value="<?php echo $this->item->{'title_' . $sef}; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
				<?php echo Text::_('HDP_DESCRIPTION'); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="description_<?php echo $sef; ?>" class="form-control"><?php echo $this->item->{'description_' . $sef}; ?></textarea>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
	            <?php echo HtmlUtils::getFieldLabel('values', Text::_('HDP_VALUES'), Text::_('HDP_EACH_ITEM_IN_ONELINE')); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="values_<?php echo $sef; ?>" class="form-control"><?php echo $this->item->{'values_' . $sef}; ?></textarea>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
				<?php echo HtmlUtils::getFieldLabel('default_values_', Text::_('HDP_DEFAULT_VALUES'), Text::_('HDP_EACH_ITEM_IN_ONELINE')); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="default_values_<?php echo $sef; ?>" class="form-control"><?php echo $this->item->{'default_values_' . $sef}; ?></textarea>
            </div>
        </div>
	<?php
	echo HTMLHelper::_($tabApiPrefix . 'endTab');
}

echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
echo HTMLHelper::_($tabApiPrefix . 'endTab');