<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSL\Utils\Html as HtmlUtils;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

HTMLHelper::_('behavior.core');
HTMLHelper::_('jquery.framework');

if (HelpdeskProHelper::isJoomla4())
{
	$tabApiPrefix = 'uitab.';
	HTMLHelper::_('script', 'system/showon.js', array('version' => 'auto', 'relative' => true));
}
else
{
	$tabApiPrefix = 'bootstrap.';
	HTMLHelper::_('script', 'jui/cms.js', false, true);
}

HTMLHelper::_('bootstrap.tooltip');

$translatable = Multilanguage::isEnabled() && count($this->languages);

$document = Factory::getDocument();
$document->addStyleDeclaration(".hasTip{display:block !important}");
$document->addScript(Uri::root(true).'/media/com_helpdeskpro/js/admin-field-default.js');
$document->addScriptOptions('validationRules', json_decode(HelpdeskProHelper::validateEngine()), true);
?>
<form action="index.php?option=com_helpdeskpro&view=field" method="post" name="adminForm" id="adminForm" class="form form-horizontal">
    <?php
    if ($translatable)
    {
        echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'field', array('active' => 'general-page'));
        echo HTMLHelper::_($tabApiPrefix . 'addTab', 'field', 'general-page', Text::_('HDP_GENERAL', true));
    }
    ?>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_CATEGORY'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['category_id']; ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo HtmlUtils::getFieldLabel('name', Text::_('HDP_NAME'), Text::_('HDP_FIELD_NAME_REQUIREMNET')); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="name" id="name" size="50" maxlength="250"
                       value="<?php echo $this->item->name; ?>" />
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_TITLE'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="title" id="title" size="50" maxlength="250"
                       value="<?php echo $this->item->title; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_FIELD_TYPE'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['fieldtype']; ?>
            </div>
        </div>
        <div class="control-group" data-showon='<?php echo HelpdeskproHelperHtml::renderShowOn(array('fieldtype' => 'List')) ?>'>
            <div class="control-label">
                <?php echo Text::_('HDP_MULTIPLE'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['multiple']; ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_DESCRIPTION'); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="description" class="form-control"><?php echo $this->item->description; ?></textarea>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_REQUIRED'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['required']; ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo HtmlUtils::getFieldLabel('values', Text::_('HDP_VALUES'), Text::_('HDP_EACH_ITEM_IN_ONELINE')); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="values" class="form-control"><?php echo $this->item->values; ?></textarea>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo HtmlUtils::getFieldLabel('default_values', Text::_('HDP_DEFAULT_VALUES'), Text::_('HDP_EACH_ITEM_IN_ONELINE')); ?>
            </div>
            <div class="controls">
                <textarea rows="5" cols="50" name="default_values" class="form-control"><?php echo $this->item->default_values; ?></textarea>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_DATATYPE_VALIDATION'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['datatype_validation']; ?>
            </div>
        </div>
        <div class="control-group validation-rules">
            <div class="control-label">
                <?php echo HtmlUtils::getFieldLabel('validation_rules', Text::_('HDP_VALIDATION_RULES'), Text::_('HDP_VALIDATION_RULES_EXPLAIN')); ?>
            </div>
            <div class="controls">
                <input type="text" class="input-xlarge form-control" size="50" name="validation_rules" value="<?php echo $this->item->validation_rules ; ?>" />
            </div>
        </div>
        <div class="control-group" data-showon='<?php echo HelpdeskproHelperHtml::renderShowOn(array('fieldtype' => 'Textarea')); ?>'>
            <div class="control-label">
                <?php echo Text::_('HDP_ROWS'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="rows" id="rows" size="10" maxlength="250" value="<?php echo $this->item->rows; ?>"/>
            </div>
        </div>
        <div class="control-group" data-showon='<?php echo HelpdeskproHelperHtml::renderShowOn(array('fieldtype' => 'Textarea')) ?>'>
            <div class="control-label">
                <?php echo Text::_('HDP_COLS'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="cols" id="cols" size="10" maxlength="250" value="<?php echo $this->item->cols; ?>"/>
            </div>
        </div>
        <div class="control-group" data-showon='<?php echo HelpdeskproHelperHtml::renderShowon(array('fieldtype' => array('Text', 'Checkboxes', 'Radio'))); ?>'>
            <div class="control-label">
                <?php echo Text::_('HDP_SIZE'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="size" id="size" size="10" maxlength="250" value="<?php echo $this->item->size; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_CSS_CLASS'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="css_class" id="css_class" size="10" maxlength="250" value="<?php echo $this->item->css_class; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_EXTRA'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="extra" id="extra" size="40" maxlength="250" value="<?php echo $this->item->extra; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo HtmlUtils::getFieldLabel('show_in_list_view', Text::_('HDP_SHOW_IN_LIST_VIEW'), Text::_('HDP_SHOW_IN_LIST_VIEW_EXPLAIN')); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['show_in_list_view']; ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_PUBLISHED'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['published']; ?>
            </div>
        </div>
    <?php

    if ($translatable)
    {
        echo HTMLHelper::_($tabApiPrefix . 'endTab');
        echo $this->loadTemplate('translation');
        echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
    }
    ?>
    <input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
    <input type="hidden" name="task" value=""/>
    <?php echo HTMLHelper::_('form.token'); ?>
</form>