<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('bootstrap.tooltip');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('formbehavior.chosen', 'select');
}

$ordering = ($this->state->filter_order == 'tbl.ordering');

if ($ordering)
{
	$saveOrderingUrl = 'index.php?option=com_helpdeskpro&task=article.save_order_ajax';
	HTMLHelper::_('sortablelist.sortable', 'articlesList', 'adminForm', strtolower($this->state->filter_order_Dir), $saveOrderingUrl);
}

$customOptions = array(
	'filtersHidden'       => true,
	'defaultLimit'        => Factory::getApplication()->get('list_limit', 20),
	'searchFieldSelector' => '#filter_search',
	'orderFieldSelector'  => '#filter_full_ordering'
);
?>
<form action="index.php?option=com_helpdeskpro&view=articles" method="post" name="adminForm" id="adminForm">
	<div class="row-fluid">
		<div id="j-sidebar-container" class="span2">
			<?php echo $this->sidebar; ?>
		</div>
		<div id="j-main-container" class="span10">
			<div id="filter-bar" class="btn-toolbar">
				<div class="filter-search btn-group pull-left">
					<label for="filter_search" class="element-invisible"><?php echo Text::_('HDP_SEARCH_ARTICLES_DESC');?></label>
					<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->filter_search); ?>" class="hasTooltip form-control" title="<?php echo HTMLHelper::tooltipText('HDP_FILTER_SEARCH_ARTICLES_DESC'); ?>" />
				</div>
				<div class="btn-group pull-left">
					<button type="submit" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span class="icon-search"></span></button>
					<button type="button" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><span class="icon-remove"></span></button>
				</div>
				<div class="btn-group pull-right hidden-phone">
					<?php echo $this->lists['filter_category_id']; ?>
					<?php echo $this->lists['filter_state']; ?>
				</div>
			</div>
			<div class="clearfix"></div>
			<table class="adminlist table table-striped" id="articlesList">
				<thead>
				<tr>
					<th width="5">
						<?php echo HTMLHelper::_('searchtools.sort', '', 'tbl.ordering', $this->state->filter_order_Dir, $this->state->filter_order, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
					</th>
					<th width="20">
						<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);"/>
					</th>
					<th class="title" style="text-align: left;">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_TITLE'), 'tbl.title', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title" style="text-align: left;">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_CATEGORY'), 'b.title', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="center">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_HITS'), 'b.hits', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th width="5%">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_PUBLISHED'), 'tbl.published', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th width="2%">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_ID'), 'tbl.id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
				</tr>
				</thead>
				<tfoot>
				<tr>
					<td colspan="7">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
				</tfoot>
				<tbody>
				<?php
				$k = 0;
				for ($i = 0, $n = count($this->items); $i < $n; $i++)
				{
					$row       = $this->items[$i];
					$link      = Route::_('index.php?option=com_helpdeskpro&view=article&id=' . $row->id);
					$checked   = HTMLHelper::_('grid.id', $i, $row->id);
					$published = HTMLHelper::_('jgrid.published', $row->published, $i);
					?>
					<tr class="<?php echo "row$k"; ?>">
						<td class="order nowrap center hidden-phone">
							<?php
							$iconClass = '';
							if (!$ordering)
							{
								$iconClass = ' inactive tip-top hasTooltip"';
							}
							?>
							<span class="sortable-handler<?php echo $iconClass ?>">
						<i class="icon-menu"></i>
						</span>
							<?php if ($ordering) : ?>
								<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $row->ordering ?>" class="width-20 text-area-order "/>
							<?php endif; ?>
						</td>
						<td>
							<?php echo $checked; ?>
						</td>
						<td>
							<a href="<?php echo $link; ?>">
									<?php echo $row->title; ?>
							</a>
						</td>
						<td>
							<?php echo $row->category_title; ?>
						</td>
						<td class="center">
							<?php echo $row->hits; ?>
						</td>
						<td class="center">
							<?php echo $published; ?>
						</td>
						<td class="center">
							<?php echo $row->id; ?>
						</td>
					</tr>
					<?php
					$k = 1 - $k;
				}
				?>
				</tbody>
			</table>
		</div>
	</div>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->state->filter_order; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->state->filter_order_Dir; ?>"/>
	<input type="hidden" id="filter_full_ordering" name="filter_full_ordering" value="" />
	<?php echo HTMLHelper::_('form.token'); ?>
</form>