<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Articles;

use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

defined('_JEXEC') or die;

class Html extends ListView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$rows = HelpdeskproHelperDatabase::getAllCategories('title', array(), '', 2);

		$this->lists['filter_category_id'] = HelpdeskproHelperHtml::buildCategoryDropdown($this->state->filter_category_id, 'filter_category_id', 'class="input-large form-select" onchange="submit();"', $rows);
	}
}