<?php
namespace BigBlueButton;
spl_autoload_register(function ($class) {
    // Namespace of your library
    $namespace = 'BigBlueButton\\';
    
    // The base directory where your library's src/ directory resides
    $baseDir = __DIR__ . '/src/';
    
    // If the namespace does not match, move to the next registered autoloader
    if (strpos($class, $namespace) !== 0) {
        return;
    }
    
    // Get the relative class name
    $relativeClass = substr($class, strlen($namespace));
    
    // Replace the namespace prefix with the base directory, replace namespace separators with directory separators
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    
    // If the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});
