<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveVideo\Table\VideoTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveVideoActivity
{

	/**
	 * render frontend video activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param VideoTable                      $video
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showVideoActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $video, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type					=	( isset( $assetMatches[3] ) ? $assetMatches[3] : '' );
		$user					=	CBuser::getMyUserDataInstance();
		$groupOwner				=	( $user->getInt( 'id', 0 ) === $video->group()->getInt( 'user_id', 0 ) );

		if ( CBGroupJive::canAccessGroup( $video->group(), $user ) ) {
			$groupName			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $video->group()->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $video->group()->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName			=	htmlspecialchars( CBTxt::T( $video->group()->getString( 'name' ) ) );
		}

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $video->group(), $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $video->group()->getInt( 'id', 0 ), 'tab' => 'grouptabvideo' ) ) );

				$videoName		=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $video->group()->getInt( 'id', 0 ), 'tab' => 'grouptabvideo' ) ) . '">' . ( $video->getString( 'title' ) ? htmlspecialchars( $video->getString( 'title' ) ) : $video->name() ) . '</a>';
			} else {
				$videoName		=	( $video->getString( 'title' ) ? htmlspecialchars( $video->getString( 'title' ) ) : $video->name() );
			}

			switch ( $type ) {
				case 'video_approve':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'VIDEO_AWAITING_APPROVAL_IN_YOUR_GROUP', 'video [video] is awaiting approval in your group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					} else {
						$title	=	CBTxt::T( 'VIDEO_AWAITING_APPROVAL_IN_GROUP', 'video [video] is awaiting approval in group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					}
					break;
				case 'video_approved':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'VIDEO_APPROVED_IN_YOUR_GROUP', 'video [video] approved in your group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					} else {
						$title	=	CBTxt::T( 'VIDEO_APPROVED_IN_GROUP', 'video [video] approved in group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					}
					break;
				case 'video_new':
				default:
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'SHARED_VIDEO_IN_YOUR_GROUP', 'shared video [video] in your group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					} else {
						$title	=	CBTxt::T( 'SHARED_VIDEO_IN_GROUP', 'shared video [video] in group [group]', array( '[group]' => $groupName, '[video]' => $videoName ) );
					}
					break;
			}
		} else {
			if ( $stream->getInt( 'groupjive.ingroup', 0 ) === $video->group()->getInt( 'id', 0 ) ) {
				$title			=	CBTxt::T( 'shared a video' );
			} elseif ( $groupOwner ) {
				$title			=	CBTxt::T( 'SHARED_A_VIDEO_IN_YOUR_GROUP', 'shared a video in your group [group]', array( '[group]' => $groupName ) );
			} else {
				$title			=	CBTxt::T( 'SHARED_A_VIDEO_IN_GROUP', 'shared a video in group [group]', array( '[group]' => $groupName ) );
			}

			$insert				=	'<div class="gjVideoActivity">'
								.		'<div class="position-relative gjGroupVideoEmbed">';

			if ( $video->mimeType() === 'video/youtube' ) {
				if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:shorts/)|(?:be/))([A-Za-z0-9_-]+)%', $video->getString( 'url' ), $matches ) ) {
					$insert		.=			'<iframe width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.youtube-nocookie.com/embed/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="encrypted-media" allowfullscreen class="position-absolute gjVideoPlayer"></iframe>';
				}
			} else {
				$insert			.=			'<video width="100%" height="100%" style="width: 100%; height: 100%;" src="' . htmlspecialchars( $video->getString( 'url' ) ) . '" type="' . htmlspecialchars( $video->mimeType() ) . '" controls="controls" preload="auto" class="position-absolute gjVideoPlayer"></video>';
			}

			$insert				.=		'</div>'
								.	'</div>';
		}

		$_PLUGINS->trigger( 'gj_onAfterVideoActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $video, $plugin, $output ) );
	}
}