<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\PMS\Table\MessageTable;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\Table\ItemTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryPM
{

	/**
	 * render frontend gallery pm
	 *
	 * @param MessageTable    $row
	 * @param ItemTable[]     $items
	 * @param UserTable       $viewer
	 * @param Gallery         $gallery
	 * @param cbPluginHandler $plugin
	 */
	static function showPM( $row, $items, $viewer, $gallery, $plugin )
	{
		global $_CB_framework;

		static $JS_LOADED				=	0;

		if ( ! $JS_LOADED++ ) {
			$_CB_framework->outputCbJQuery( "$( '.galleryModalToggle' ).cbgallery();", 'cbgallery' );
		}

		$totalItems						=	count( $items );

		$class							=	$plugin->params->getString( 'general_class' );
		$returnUrl						=	base64_encode( $gallery->location() );

		$return							=	'<div class="mt-2 pmMessageAttachments">'
										.		'<div class="cbGallery' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
										.			'<div class="' . ( $totalItems > 1 ? 'd-flex flex-wrap no-gutters ' : null ) . 'galleryPM">';

		$i								=	0;

		foreach ( $items as $item ) {
			if ( ! $item->exists() ) {
				continue;
			}

			$data						=	array();

			if ( $totalItems > 1 ) {
				$data['previous']		=	( $i === 0 ? ( $totalItems - 1 ) : ( $i - 1 ) );
				$data['next']			=	( ( $i + 1 ) <= ( $totalItems - 1 )  ? ( $i + 1 ) : 0 );
			}

			$isFileImage				=	( ( $item->getString( 'type' ) === 'files' ) && ( ( $item->extension() === 'svg' ) || ( CBGallery::getExtensionType( $item->extension() ) === 'photos' ) ) );
			$displayPath				=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'display', 'id' => $item->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ), 'raw', 0, true );
			$modal						=	cbTooltip( null, null, null, array( '90%', '90%' ), null, null, null, 'data-hascbtooltip="true" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".galleryModal" data-cbtooltip-classes="galleryModal" data-cbtooltip-content-classes="p-0" data-cbtooltip-button-close="false" data-cbgallery-url="' . $displayPath . '" data-cbgallery-request="' . htmlspecialchars( json_encode( $data ) ) . '"' );
			$itemId						=	md5( $gallery->id() . '_' . $item->getInt( 'id', 0 ) );

			if ( $totalItems === 1 ) {
				if ( ( $item->getString( 'type' ) === 'photos' ) || $isFileImage ) {
					$return				.=				'<a href="javascript: void(0);" class="galleryItemEmbed galleryModalToggle"' . $modal . '>'
										.					HTML_cbgalleryEmbed::showEmbed( $item, $viewer, $gallery, $plugin, true )
										.				'</a>';
				} else {
					$return				.=				HTML_cbgalleryEmbed::showEmbed( $item, $viewer, $gallery, $plugin );
				}
			} else {
				$embed					=	$item->thumbnail( $gallery );
				$solid					=	( ( ! in_array( $item->getString( 'type' ), array( 'photos', 'videos' ), true ) ) && ( ! $isFileImage ) && ( ! $item->getString( 'thumbnail' ) ) );

				if ( ( $i === 5 ) && ( $totalItems > 6 ) ) {
					$embed				.=	'<div class="position-absolute d-flex h-100 w-100 justify-content-center align-items-center bg-dark galleryContainerMore">'
										.		'<span class="display-4 align-middle text-white galleryImageIcon">+' . ( $totalItems - 5 ) . '</span>'
										.	'</div>';

					$solid				=	false;
				}

				$return					.=				'<div class="position-relative col-6 col-sm-4 col-lg-3 galleryItemContainer galleryContainer galleryContainer' . htmlspecialchars( ucfirst( $item->getString( 'type' ) ) ) . ( $i === 0 ? ' galleryContainerFirst' : null ) . ' galleryContainer' . $itemId . ( $solid ? ' galleryContainerSolid' : null ) . ( $i > 5 ? ' hidden' : null ) . '">'
										.					'<div class="card position-absolute w-100 h-100 no-overflow rounded-0 cbCanvasLayout cbCanvasLayoutHover">'
										.						'<div class="card-header rounded-0 p-0 border-0 w-100 h-100 cbCanvasLayoutTop">'
										.							'<a href="javascript: void(0);" class="d-flex h-100 w-100 justify-content-center align-items-center galleryItemEmbed galleryModalToggle"' . $modal . '>' . $embed . '</a>'
										.						'</div>';

				if ( $solid ) {
					$itemTitle			=	( $item->getString( 'title' ) ? $item->getString( 'title' ) : $item->name() );

					$return				.=						'<div class="position-absolute card-footer rounded-0 p-1 bg-white cbCanvasLayoutFooter">'
										.							'<div class="text-truncate cbCanvasLayoutContent">'
										.							'<a href="javascript: void(0);" class="galleryItemName galleryModalToggle"' . $modal . '>' . $itemTitle . '</a>'
										.							'</div>'
										.						'</div>';
				}

				$return					.=					'</div>'
										.				'</div>';
			}

			$i++;
		}

		$return							.=			'</div>'
										.		'</div>'
										.	'</div>';

		return $return;
	}
}