<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItemEditMini
{

	/**
	 * @param ItemTable        $row
	 * @param array            $input
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 * @param string           $output
	 * @return string
	 */
	public static function showItemEditMini( $row, $input, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework, $_PLUGINS;

		$beforeIntegrations		=	implode( '', $_PLUGINS->trigger( 'gallery_onBeforeItemEditMini', array( &$row, &$input, $viewer, $gallery ) ) );

		static $JS_LOADED		=	0;

		if ( ! $JS_LOADED++ ) {
			$editError			=	'<div class="galleryEditError alert alert-danger">'
								.		"' + response.message + '"
								.	'</div>';

			$js					=	"$( '.galleryItemEditMini select.galleryCBSelect' ).cbselect({ width: '100%' });"
								.	"$( '.galleryEdit' ).cbgallery({"
								.		"mode: 'edit',"
								.		"callback: {"
								.			"delete: {"
								.				"error: function ( cbgallery, response ) {"
								.					"return $( '" . $editError . "' );"
								.				"}"
								.			"},"
								.			"edit: {"
								.				"error: function ( cbgallery, response ) {"
								.					"return $( '" . $editError . "' );"
								.				"}"
								.			"}"
								.		"}"
								.	"});";

			$_CB_framework->outputCbJQuery( $js, array( 'cbselect', 'cbgallery' ) );
		}

		$type					=	$row->getString( 'type' );

		$afterIntegrations		=	implode( '', $_PLUGINS->trigger( 'gallery_onAfterItemEditMini', array( $row, $input, $viewer, $gallery ) ) );

		$return					=	'<div class="card mb-3 no-overflow galleryEdit galleryItemEditMini">'
								.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'save', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" method="post" enctype="multipart/form-data" name="galleryItemForm" class="form-auto m-0 cb_form galleryEditForm galleryItemForm cbValidation">'
								.			'<div class="d-flex flex-wrap no-gutters p-0 card-body">'
								.				'<div class="col-sm-4 galleryItemEditMiniPreview">'
								.					HTML_cbgalleryItemContainer::showItemContainer( $row, $viewer, $gallery, $plugin, 'compact' )
								.				'</div>'
								.				'<div class="col-sm-8 p-3 d-flex flex-column galleryItemEditMiniRows">'
								.					( $beforeIntegrations ? '<div class="mb-3 galleryItemEditBeforeIntegrations">' . $beforeIntegrations . '</div>' : null )
								.					'<div class="d-flex flex-wrap no-gutters">';

		if ( $gallery->getBool( 'folders', true ) && $input['folder'] ) {
			$return				.=						'<div class="col-sm-7 pr-sm-2 galleryItemEditMiniTitle">'
								.							'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line cbtwolinesfield">'
								.								'<label for="title' . $row->getInt( 'id' ) . '" class="col-form-label col-sm-12 pt-0">' . CBTxt::T( 'Title' ) . '</label>'
								.								'<div class="cb_field col-sm-12">'
								.									$input['title']
								.								'</div>'
								.							'</div>'
								.						'</div>'
								.						'<div class="col-sm-5 galleryItemEditMiniAlbum">'
								.							'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line cbtwolinesfield">'
								.								'<label for="folder' . $row->getInt( 'id' ) . '" class="col-form-label col-sm-12 pt-0">' . CBTxt::T( 'Album' ) . '</label>'
								.								'<div class="cb_field col-sm-12">'
								.									$input['folder']
								.								'</div>'
								.							'</div>'
								.						'</div>';
		} else {
			$return				.=						'<div class="col-sm-12 galleryItemEditMiniTitle">'
								.							'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line cbtwolinesfield">'
								.								'<label for="title' . $row->getInt( 'id' ) . '" class="col-form-label col-sm-12 pt-0">' . CBTxt::T( 'Title' ) . '</label>'
								.								'<div class="cb_field col-sm-12">'
								.									$input['title']
								.								'</div>'
								.							'</div>'
								.						'</div>';
		}

		$return					.=					'</div>'
								.					'<div class="flex-grow-1 galleryItemEditMiniDescription">'
								.						'<div class="m-0 h-100 cbft_textarea cbtt_textarea form-group d-flex flex-wrap no-gutters flex-column cb_form_line cbtwolinesfield">'
								.							'<label for="description' . $row->getInt( 'id' ) . '" class="col-form-label pt-0">' . CBTxt::T( 'Description' ) . '</label>'
								.							'<div class="flex-grow-1 cb_field">'
								.								$input['description']
								.							'</div>'
								.						'</div>'
								.					'</div>'
								.					( $afterIntegrations ? '<div class="mt-3 galleryItemEditAfterIntegrations">' . $afterIntegrations . '</div>' : null )
								.				'</div>'
								.			'</div>'
								.			'<div class="text-right p-2 card-footer">'
												// CBTxt::T( 'ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
								.				'<button type="button" class="btn btn-sm btn-danger btn-sm-block galleryEditDelete galleryButton galleryButtonDelete" data-cbgallery-delete-message="' . htmlspecialchars( CBTxt::T( 'ARE_YOU_SURE_DELETE_' . strtoupper( $type ) . ' ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '" data-cbgallery-delete-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . CBTxt::T( 'Delete' ) . '</button>'
								.				' <button type="submit" class="btn btn-sm btn-primary btn-sm-block galleryEditSave galleryButton galleryButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . CBTxt::T( 'Save' ) . '</button>'
								.			'</div>'
								.			cbGetSpoofInputTag( 'plugin' )
								.		'</form>'
								.		'<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-dark text-white galleryEditLoading hidden"><div class="spinner-border spinner-border-sm"></div></div>'
								.		( $output === 'ajax' ? CBGallery::reloadHeaders() : null )
								.	'</div>';

		return $return;
	}
}