<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Table\FolderTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryFolderContainer
{

	/**
	 * @param FolderTable      $row
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 * @param string           $output
	 * @return string
	 */
	public static function showFolderContainer( $row, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework, $_PLUGINS;

		$canModerate					=	CBGallery::canModerate( $gallery );

		$menu							=	array();

		$content						=	$_PLUGINS->trigger( 'gallery_onDisplayFolder', array( &$row, &$menu, $gallery, $output ) );

		$owner							=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
		$title							=	( $row->getString( 'title' ) ? $row->getString( 'title' ) : cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_SHORT_DATE_FORMAT', 'M j, Y' ) ) );
		$pending						=	( ( $row->getInt( 'published', 1 ) === -1 ) && $gallery->getBool( 'folders_create_approval', false ) );

		$returnUrl						=	base64_encode( $gallery->location() );

		$buttons						=	array();

		if ( $output === 'approval' ) {
			$buttons[]					=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="btn btn-sm btn-success galleryButton galleryButtonApprove">' . CBTxt::T( 'Approve' ) . '</a>';
		}

		if ( ( ! in_array( $output, array( 'compact', 'preview', 'module' ), true ) ) && ( $canModerate || $owner || $menu ) ) {
			$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 galleryMenuItems">';

			if ( $menu ) {
				$menuItems				.=		'<li class="galleryMenuItem">' . implode( '</li><li class="galleryMenuItem">', $menu ) . '</li>';
			}

			if ( $canModerate || $owner ) {
				$menuItems				.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( $output !== 'approval' ) {
					if ( $pending ) {
						if ( $canModerate ) {
							$menuItems	.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
						}
					} elseif ( $row->getInt( 'published', 1 ) > 0 ) {
						$menuItems		.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this album?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
					} else {
						$menuItems		.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
					}
				}

				$menuItems				.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this album and all its files?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
			}

			$menuItems					.=	'</ul>';

			$menuAttr					=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm' . ( $output !== 'approval' ? ' cbCanvasLayoutHoverMenu' : null ) . ' cbCanvasLayoutMenu galleryContainerMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

			$buttons[]					=	'<button type="button" ' . trim( $menuAttr ) . ' aria-label="' . htmlspecialchars( CBTxt::T( 'Album Menu' ) ) . '"><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
		}

		$return							=	'<div class="position-relative' . ( ! in_array( $output, array( 'compact', 'preview' ), true ) ? ' col-6' . ( $output !== 'module' ? ' col-sm-4 col-lg-3' : null ) : null ) . ' galleryFolderContainer galleryContainer galleryContainerFolders galleryContainerSolid">'
										.		'<div class="card position-absolute w-100 h-100 no-overflow rounded-0 cbCanvasLayout cbCanvasLayoutHover">'
										.			'<div class="card-header rounded-0 p-0 border-0 w-100 h-100 cbCanvasLayoutTop">'
										.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ) ) . '" class="d-flex h-100 w-100 justify-content-center align-items-center galleryItemEmbed" aria-label="' . htmlspecialchars( $title ) . '"' . ( $output !== 'preview' ? ' tabindex="-1"' : null ) . '>'
										.					$row->thumbnail( $gallery, -1 )
										.				'</a>';

		if ( $buttons ) {
			$return						.=				'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
										.					implode( ' ', $buttons )
										.				'</div>';
		}

		$return							.=			'</div>';

		if ( $output !== 'preview' ) {
			$return						.=			'<div class="position-absolute card-footer rounded-0 p-1 bg-white cbCanvasLayoutFooter">'
										.				'<div class="text-truncate text-large cbCanvasLayoutContent">'
										.					'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ) ) . '">'
										.						$title
										.					'</a>'
										.				'</div>';

			if ( ! in_array( $output, array( 'compact', 'module' ), true ) ) {
				$icons					=	array();

				if ( $pending ) {
					$icons[]			=	cbTooltip( null, CBTxt::T( 'Pending Approval' ), null, 'auto', null, '<span class="fa fa-warning text-warning"></span>', null, 'class="galleryContainerIconPending" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
				} elseif ( $row->getInt( 'published', 1 ) !== 1 ) {
					$icons[]			=	cbTooltip( null, CBTxt::T( 'Unpublished' ), null, 'auto', null, '<span class="fa fa-eye-slash"></span>', null, 'class="galleryContainerIconUnpublished" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
				}

				$return					.=				'<div class="d-none d-sm-flex text-small text-muted d-flex flex-wrap no-gutters cbCanvasLayoutContent">'
										.					'<div class="text-truncate' . ( $icons ? ' col-sm-6' : null ) . ' cbCanvasLayoutContent">'
										.						CBTxt::T( 'COUNT_FILES', '%%COUNT%% File|%%COUNT%% Files|{0}Empty', array( '%%COUNT%%' => $row->items( true, $gallery ) ) )
										.					'</div>';

				if ( $icons ) {
					$return				.=					'<div class="text-truncate col-sm-6 text-sm-right cbCanvasLayoutContent">'
										.						implode( ' ', $icons )
										.					'</div>';
				}

				$return					.=				'</div>'
										.				( $content ? '<div class="cbCanvasLayoutContent galleryContainerIntegrations">' . implode( '', $content ) . '</div>' : null );
			}

			$return						.=			'</div>';
		}

		$return							.=		'</div>'
										.	'</div>';

		return $return;
	}
}