<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Comments;
use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Gallery\Table\ItemTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryActivityEdit
{

	/**
	 * render frontend activity gallery edit
	 *
	 * @param ActivityTable|CommentTable $row
	 * @param ItemTable[]                $items
	 * @param array                      $buttons
	 * @param UserTable                  $viewer
	 * @param Activity|Comments          $stream
	 * @param Gallery                    $gallery
	 * @param cbPluginHandler            $plugin
	 * @param string                     $output
	 * @return mixed
	 */
	static function showActivityEdit( $row, $items, &$buttons, $viewer, $stream, $gallery, $plugin, $output = null )
	{
		if ( ! CBGallery::canCreateItems( 'all', 'upload', $gallery ) ) {
			return null;
		}

		$class			=	$plugin->params->getString( 'general_class' );

		$return			=	'<div class="' . ( $stream instanceof Comments ? 'bg-white border border-top-0' : 'border-top' ) . ' p-2 streamItemInputGroup streamInputUploadContainer">'
						.		'<div class="streamItemInputGroupInput">'
						.			'<div class="cbGallery' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
						.				'<div class="d-flex flex-wrap no-gutters galleryActivityEdit galleryItemsEdit">';

		foreach ( $items as $item ) {
			$return		.=					HTML_cbgalleryItemEditMicro::showItemEditMicro( $item, $viewer, $gallery, $plugin, $output );
		}

		$return			.=				'</div>'
						.			'</div>'
						.		'</div>'
						.	'</div>';

		return $return;
	}
}