<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\ProfileUpdateLogger\Table;

use CB\Plugin\ProfileUpdateLogger\CBProfileUpdateLogger;
use CBLib\Application\Application;
use CBLib\Database\Table\Table;
use CBLib\Language\CBTxt;

defined('CBLIB') or die();

class UpdateLogTable extends Table
{
	/** @var int  */
	public $id				=	null;
	/** @var string  */
	public $changedate		=	null;
	/** @var int  */
	public $profileid		=	null;
	/** @var string  */
	public $editedbyip		=	null;
	/** @var int  */
	public $editedbyid		=	null;
	/** @var string  */
	public $mode			=	null;
	/** @var string  */
	public $fieldname		=	null;
	/** @var string  */
	public $oldvalue		=	null;
	/** @var int  */
	public $newvalue		=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plug_pulogger';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getInt( 'profileid', 0 ) ) {
			$this->setError( CBTxt::T( 'User not specified!' ) );

			return false;
		}

		if ( $this->getString( 'fieldname', '' ) === '' ) {
			$this->setError( CBTxt::T( 'Field not specified!' ) );

			return false;
		}

		if ( $this->getRaw( 'oldvalue' ) === $this->getRaw( 'newvalue' ) ) {
			$this->setError( CBTxt::T( 'Value is unchanged!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$ipAddresses	=	cbGetIParray();
		$new			=	( ! $this->getInt( 'id', 0 ) );
		$old			=	new self();

		$this->set( 'changedate', $this->getString( 'changedate', Application::Database()->getUtcDateTime() ) );

		if ( CBProfileUpdateLogger::getGlobalParams()->getBool( 'logging_ip', false ) ) {
			$this->set( 'editedbyip', $this->getString( 'editedbyip', trim( array_shift( $ipAddresses ) ) ) );
		}

		$this->set( 'editedbyid', $this->getInt( 'editedbyid', Application::MyUser()->getUserId() ) );
		$this->set( 'mode', $this->getInt( 'mode', ( Application::Application()->isClient( 'administrator' ) ? 1 : 0 ) ) );

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			$_PLUGINS->trigger( 'pu_onBeforeUpdateLog', array( &$this, $old ) );
		} else {
			$_PLUGINS->trigger( 'pu_onBeforeCreateLog', array( &$this ) );
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'pu_onAfterUpdateLog', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'pu_onAfterCreateLog', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		$_PLUGINS->trigger( 'pu_onBeforeDeleteLog', array( &$this ) );

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		$_PLUGINS->trigger( 'pu_onAfterDeleteLog', array( $this ) );

		return true;
	}

	/**
	 * @param null|bool $format
	 * @return null|string
	 */
	public function getFieldName( $format = null )
	{
		$name		=	$this->getString( 'fieldname' );

		if ( $format === null ) {
			$format	=	CBProfileUpdateLogger::getGlobalParams()->getBool( 'log_format_names', false );
		}

		if ( $format ) {
			$title	=	CBProfileUpdateLogger::getFieldTitle( $name, $this->getInt( 'profileid', 0 ) );

			if ( $title ) {
				return $title;
			}
		}

		return $name;
	}

	/**
	 * @return string
	 */
	public function isCompare()
	{
		$compareTypes		=	explode( '|*|', CBProfileUpdateLogger::getGlobalParams()->getString( 'log_modal_types', 'fieldgroup|*|editorta' ) );
		$compareLength		=	CBProfileUpdateLogger::getGlobalParams()->getInt( 'log_modal_length', 100 );

		if ( ( ! $compareTypes ) && ( ! $compareLength ) ) {
			return false;
		}

		static $cache		=	array();

		$id					=	$this->getInt( 'id', 0 );

		if ( isset( $cache[$id] ) ) {
			return $cache[$id];
		}

		$cache[$id]			=	false;

		if ( $compareLength ) {
			if ( strlen( $this->getRaw( 'oldvalue' ) ) >= $compareLength ) {
				$cache[$id]	=	true;

				return true;
			}

			if ( strlen( $this->getRaw( 'newvalue' ) ) >= $compareLength ) {
				$cache[$id]	=	true;

				return true;
			}
		}

		if ( $compareTypes ) {
			$field			=	CBProfileUpdateLogger::getField( $this->getString( 'fieldname' ), $this->getInt( 'profileid', 0 ) );

			if ( $field ) {
				$cache[$id]	=	in_array( $field->getString( 'type' ), $compareTypes, true );

				return $cache[$id];
			}
		}

		return false;
	}

	/**
	 * @param null|bool $format
	 * @return string
	 */
	public function getOldValue( $format = null )
	{
		$value				=	$this->getRaw( 'oldvalue' );

		if ( ( $value === null ) || ( $value === '' ) ) {
			return CBTxt::T( 'UPDATE_LOG_FIELD_EMPTY', '(empty)' );
		}

		if ( $format === null ) {
			$format			=	CBProfileUpdateLogger::getGlobalParams()->getBool( 'log_format_values', false );
		}

		if ( $format ) {
			$fieldValue		=	CBProfileUpdateLogger::getFieldValue( $this->getString( 'fieldname' ), $value, $this->getInt( 'profileid', 0 ) );

			if ( ( $fieldValue !== null ) && ( $fieldValue !== '' ) ) {
				return $fieldValue;
			}
		}

		return htmlspecialchars( $value );
	}

	/**
	 * @param null|bool $format
	 * @return string
	 */
	public function getNewValue( $format = null )
	{
		$value				=	$this->getRaw( 'newvalue' );

		if ( ( $value === null ) || ( $value === '' ) ) {
			return CBTxt::T( 'UPDATE_LOG_FIELD_EMPTY', '(empty)' );
		}

		if ( $format === null ) {
			$format			=	CBProfileUpdateLogger::getGlobalParams()->getBool( 'log_format_values', false );
		}

		if ( $format ) {
			$fieldValue		=	CBProfileUpdateLogger::getFieldValue( $this->getString( 'fieldname' ), $value, $this->getInt( 'profileid', 0 ) );

			if ( ( $fieldValue !== null ) && ( $fieldValue !== '' ) ) {
				return $fieldValue;
			}
		}

		return htmlspecialchars( $value );
	}
}