<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJiveFile/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjivefile_install()
{
	// Grab GJ params to migrate the legacy params:
	$plugin				=	new PluginTable();

	$plugin->load( array( 'element' => 'cbgroupjive' ) );

	$pluginParams		=	new Registry( $plugin->getRaw( 'params', array() ) );

	if ( ( ! $pluginParams->has( 'file_captcha' ) ) || ( $pluginParams->getInt( 'file_captcha' ) === null ) ) {
		return;
	}

	// Migrate file integration parameters:
	$file				=	new PluginTable();

	$file->load( array( 'element' => 'cbgroupjivefile' ) );

	$fileParams			=	new Registry( $file->getRaw( 'params', array() ) );

	if ( $fileParams->getBool( 'migrated', false ) ) {
		return;
	}

	$fileParams->set( 'groups_file_captcha', $pluginParams->getInt( 'file_captcha', 0 ) );
	$fileParams->set( 'groups_file_max_size', $pluginParams->getInt( 'file_maxsize', 0 ) );
	$fileParams->set( 'groups_file_extensions', $pluginParams->getString( 'file_types' ) );
	$fileParams->set( 'groups_file_paging', $pluginParams->getInt( 'file_paging', 0 ) );
	$fileParams->set( 'groups_file_limit', $pluginParams->getInt( 'file_limit' ) );
	$fileParams->set( 'groups_file_search', $pluginParams->getInt( 'file_search', 0 ) );
	$fileParams->set( 'migrated', true );

	$file->set( 'params', $fileParams->asJson() );

	$file->store();
}