<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CB\Plugin\AutoActions\CBAutoActions;
use CBLib\Language\CBTxt;

\defined( 'CBLIB' ) or die();

class RedirectAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_framework;

		$params						=	$this->autoaction()->getParams()->subTree( 'redirect' );
		$redirect					=	$this->string( $user, $params->getString( 'url', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $params->getString( 'url', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

		if ( ! $redirect ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_REDIRECT_NO_URL', ':: Action [action] :: Redirect skipped due to missing url', [ '[action]' => $this->autoaction()->getId() ] ) );
			return;
		}

		$message					=	$this->string( $user, $params->getRaw( 'message', '' ), false );
		$messageType				=	$params->getString( 'type', 'message' );

		if ( $messageType === 'custom' ) {
			$messageType			=	$this->string( $user, $params->getString( 'custom_type', '' ) );
		}

		if ( stripos( $redirect, 'goback' ) === 0 ) {
			$back					=	(int) strtolower( substr( $redirect, 6 ) );

			if ( $message ) {
				$_CB_framework->enqueueMessage( $message, ( $messageType ?: null ) );
			}

			$_CB_framework->document->addHeadScriptDeclaration( ( $back && ( $back > 0 ) ? "window.history.go( -$back );" : "window.history.back();" ) );
		} elseif ( strtolower( $redirect ) === 'reload' ) {
			if ( $message ) {
				$_CB_framework->enqueueMessage( $message, ( $messageType ?: null ) );
			}

			$_CB_framework->document->addHeadScriptDeclaration( "window.location.reload();" );
		} else {
			if ( strtolower( $redirect ) === 'return' ) {
				$redirect			=	CBAutoActions::getCurrentURL();

				if ( preg_match( '/index.php\?option=com_comprofiler&task=confirm&confirmCode=|index.php\?option=com_comprofiler&view=confirm&confirmCode=|index.php\?option=com_comprofiler&task=login|index.php\?option=com_comprofiler&view=login/', $redirect ) ) {
					$redirect		=	'index.php';
				}
			} elseif ( strpos( $redirect, 'index.php?Itemid=' ) === 0 ) {
				// We're linking to another menu item so lets run through SEF before redirecting so we have the ACTUAL menu URL:
				$redirect			=	cbSef( $redirect, false );
			}

			cbRedirect( $redirect, $message, ( $message ? ( $messageType ?: null ) : null ) );
		}
	}
}