<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CB\Plugin\AutoActions\CBAutoActions;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class PiwikAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_framework;

		$userAgent							=	Application::Input()->getNamespaceRegistry( 'server' )->getString( 'HTTP_USER_AGENT', '' );
		$userLanguage						=	$user->getUserLanguage();

		if ( ! $userLanguage ) {
			$userLanguage					=	Application::Cms()->getLanguageTag();
		}

		$ipAddresses						=	cbGetIParray();
		$ipAddress							=	null;

		if ( $ipAddresses ) {
			$ipAddress						=	trim( array_shift( $ipAddresses ) );
		}

		foreach ( $this->autoaction()->getParams()->subTree( 'piwik' ) as $row ) {
			/** @var ParamsInterface $row */
			$installation					=	$this->string( $user, $row->getString( 'installation', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $row->getString( 'installation', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

			if ( ! $installation ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PIWIK_NO_INSTALLATION', ':: Action [action] :: Tracking skipped due to missing installation url', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			if ( strpos( $installation, '/' ) === 0 ) {
				$installation				=	$_CB_framework->getCfg( 'live_site' ) . $installation;
			}

			$installation					.=	'/piwik.php';
			$site							=	$this->string( $user, $row->getString( 'site', '' ) );

			if ( ! $site ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PIWIK_NO_SITE', ':: Action [action] :: Tracking skipped due to missing site id', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$url							=	$this->string( $user, $row->getString( 'url', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $row->getString( 'url', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

			if ( ! $url ) {
				$url						=	CBAutoActions::getCurrentURL();
			}

			if ( ! $url ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PIWIK_NO_URL', ':: Action [action] :: Tracking skipped due to missing url', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$token							=	$this->string( $user, $row->getString( 'token', '' ) );
			$client							=	new \GuzzleHttp\Client();

			try {
				$uid						=	$this->string( $user, $row->getString( 'user', '' ) );

				if ( ! $uid ) {
					$uid					=	md5( $user->getInt( 'id', 0 ) . $_CB_framework->getCfg( 'live_site' ) );
				}

				$body						=	[ 'idsite' => $site, 'rec' => 1, 'url' => $url, 'uid' => $uid ];

				$visitor					=	$this->string( $user, $row->getString( 'visitor', '' ) );

				if ( $visitor ) {
					$body['_id']			=	$visitor;
				}

				$action						=	$this->string( $user, $row->getString( 'action.name', '' ) );

				if ( $action ) {
					$body['action_name']	=	$action;
				}

				$link						=	$this->string( $user, $row->getString( 'action.link', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $row->getString( 'action.link', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

				if ( $link ) {
					$body['link']			=	str_replace( '[current_url]', CBAutoActions::getCurrentURL(), $link );
				}

				$download					=	$this->string( $user, $row->getString( 'action.download', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $row->getString( 'action.download', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

				if ( $download ) {
					$body['download']		=	str_replace( '[current_url]', CBAutoActions::getCurrentURL(), $download );
				}

				$campaign					=	$this->string( $user, $row->getString( 'campaign.name', '' ) );

				if ( $campaign ) {
					$body['_rcn']			=	$campaign;
				}

				$campaignKeyword			=	$this->string( $user, $row->getString( 'campaign.keyword', '' ) );

				if ( $campaignKeyword ) {
					$body['_rck']			=	$campaignKeyword;
				}

				$eventCategory				=	$this->string( $user, $row->getString( 'event.category', '' ) );
				$eventAction				=	$this->string( $user, $row->getString( 'event.action', '' ) );

				if ( $eventCategory && $eventAction ) {
					$body['e_c']			=	$eventCategory;
					$body['e_a']			=	$eventAction;

					$eventName				=	$this->string( $user, $row->getString( 'event.name', '' ) );

					if ( $eventName ) {
						$body['e_n']		=	$eventName;
					}

					$eventValue				=	$this->string( $user, $row->getString( 'event.value', '' ) );

					if ( $eventValue ) {
						$body['e_v']		=	$eventValue;
					}
				}

				$contentName				=	$this->string( $user, $row->getString( 'content.name', '' ) );

				if ( $contentName ) {
					$body['c_n']			=	$contentName;
				}

				$contentPiece				=	$this->string( $user, $row->getString( 'content.piece', '' ) );

				if ( $contentPiece ) {
					$body['c_p']			=	$contentPiece;
				}

				$contentTarget				=	$this->string( $user, $row->getString( 'content.target', '' ) );

				if ( $contentTarget ) {
					$body['c_t']			=	$contentTarget;
				}

				$contentInteraction			=	$this->string( $user, $row->getString( 'content.interaction', '' ) );

				if ( $contentInteraction ) {
					$body['c_i']			=	$contentInteraction;
				}

				$ecommerceOrder				=	$this->string( $user, $row->getString( 'ecommerce.order', '' ) );

				if ( $ecommerceOrder ) {
					$body['idgoal']			=	0;
					$body['ec_id']			=	$ecommerceOrder;

					$ecommerceTax			=	$this->string( $user, $row->getString( 'ecommerce.tax', '' ) );

					if ( $ecommerceTax ) {
						$body['ec_tx']		=	$ecommerceTax;
					}

					$ecommerceShipping		=	$this->string( $user, $row->getString( 'ecommerce.shipping', '' ) );

					if ( $ecommerceShipping ) {
						$body['ec_sh']		=	$ecommerceShipping;
					}

					$ecommerceDiscount		=	$this->string( $user, $row->getString( 'ecommerce.discount', '' ) );

					if ( $ecommerceDiscount ) {
						$body['ec_dt']		=	$ecommerceDiscount;
					}

					$ecommerceSubtotal		=	$this->string( $user, $row->getString( 'ecommerce.subtotal', '' ) );

					if ( $ecommerceSubtotal ) {
						$body['ec_st']		=	$ecommerceSubtotal;
					}

					$ecommerceRevenue		=	$this->string( $user, $row->getString( 'ecommerce.revenue', '' ) );

					if ( $ecommerceRevenue ) {
						$body['revenue']	=	$ecommerceRevenue;
					}

					$items					=	[];
					$in						=	1;

					foreach ( $row->subTree( 'ecommerce.items' ) as $item ) {
						/** @var ParamsInterface $item */
						$sku				=	$item->getString( 'sku', '' );

						if ( $sku ) {
							$items[$in]		=	[	$sku,
													$this->string( $user, $item->getString( 'name', '' ) ),
													$this->string( $user, $item->getString( 'category', '' ) ),
													$this->string( $user, $item->getString( 'price', '' ) ),
													$this->string( $user, $item->getString( 'quantity', '' ) )
												];

							$in++;
						}
					}

					if ( $items ) {
						$body['ec_items']	=	json_encode( $items );
					}
				} else {
					$goal					=	$this->string( $user, $row->getString( 'goal', '' ) );

					if ( $goal ) {
						$body['idgoal']		=	$goal;
					}
				}

				$custom						=	[];
				$cn							=	1;

				foreach ( $row->subTree( 'custom' ) as $customVariable ) {
					/** @var ParamsInterface $customVariable */
					$key					=	$customVariable->getString( 'key', '' );

					if ( $key ) {
						$custom[$cn]		=	[ $key, $this->string( $user, $customVariable->getString( 'value', '' ) ) ];

						$cn++;
					}
				}

				if ( $custom ) {
					$body['_cvar']			=	json_encode( $custom );
				}

				$agent						=	$this->string( $user, $row->getString( 'location.useragent', '' ) );

				if ( ! $agent ) {
					$agent					=	$userAgent;
				}

				if ( $agent ) {
					$body['ua']				=	$agent;
				}

				$language					=	$this->string( $user, $row->getString( 'location.language', '' ) );

				if ( ! $language ) {
					$language				=	$userLanguage;
				}

				if ( $agent ) {
					$body['lang']			=	$language;
				}

				if ( $token ) {
					$ip						=	$this->string( $user, $row->getString( 'location.ipaddress', '' ) );

					if ( ! $ip ) {
						$ip					=	$ipAddress;
					}

					if ( $ip ) {
						$body['cip']		=	$ip;
					}

					$country				=	cbutf8_strtolower( $this->string( $user, $row->getString( 'location.country', '' ) ) );

					if ( $country ) {
						$body['country']	=	$country;
					}

					$region					=	cbutf8_strtoupper( $this->string( $user, $row->getString( 'location.region', '' ) ) );

					if ( $region ) {
						$body['region']		=	$region;
					}

					$city					=	$this->string( $user, $row->getString( 'location.city', '' ) );

					if ( $city ) {
						$body['city']		=	$city;
					}

					$latitude				=	$this->string( $user, $row->getString( 'location.latitude', '' ) );

					if ( $latitude ) {
						$body['lat']		=	$latitude;
					}

					$longitude				=	$this->string( $user, $row->getString( 'location.longitude', '' ) );

					if ( $longitude ) {
						$body['long']		=	$longitude;
					}

					$body['token_auth']		=	$token;
				}

				$result						=	$client->get( $installation, [ 'query' => $body ] );

				if ( (int) $result->getStatusCode() !== 200 ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_PIWIK_FAILED', ':: Action [action] :: Tracking failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $result->getStatusCode() ] ) );
					continue;
				}
			} catch ( \Exception $e ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PIWIK_FAILED', ':: Action [action] :: Tracking failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
				continue;
			}
		}
	}
}