<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class EmailAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_database;

		$moderatorViewAccessLevels						=	Application::CmsPermissions()->getGroupsOfViewAccessLevel( Application::Config()->getInt( 'moderator_viewaccesslevel', 3 ), true );

		if ( $moderatorViewAccessLevels ) {
			static $moderators							=	null;

			if ( $moderators === null ) {
				$query									=	'SELECT DISTINCT u.' . $_CB_database->NameQuote( 'email' )
														.	"\n FROM " . $_CB_database->NameQuote( '#__users' ) . " AS u"
														.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS c"
														.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'id' )
														.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__user_usergroup_map' ) . " AS g"
														.	' ON g.' . $_CB_database->NameQuote( 'user_id' ) . ' = c.' . $_CB_database->NameQuote( 'id' )
														.	"\n WHERE g." . $_CB_database->NameQuote( 'group_id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $moderatorViewAccessLevels )
														.	"\n AND u." . $_CB_database->NameQuote( 'block' ) . " = 0"
														.	"\n AND c." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
														.	"\n AND c." . $_CB_database->NameQuote( 'approved' ) . " = 1";

				$_CB_database->setQuery( $query );
				$moderators								=	$_CB_database->loadResultArray();
			}

			if ( $moderators ) {
				$substitutions							=	$this->substitutions();

				$substitutions['cb_moderators']			=	implode( ',', $moderators );
			}
		}

		foreach ( $this->autoaction()->getParams()->subTree( 'email' ) as $row ) {
			/** @var ParamsInterface $row */
			$mailTo										=	$row->getString( 'to', '' );
			$mailToLanguage								=	null;

			if ( ! $mailTo ) {
				$mailTo									=	$user->getString( 'email', '' );
				$mailToLanguage							=	$user->getUserLanguage();
			} else {
				$mailTo									=	$this->string( $user, $mailTo );

				if ( $mailTo ) {
					$mailTo								=	preg_split( '/ *, */', $mailTo );

					foreach ( $mailTo as $k => $mailToEmail ) {
						if ( is_numeric( $mailToEmail ) ) {
							$mailToUser					=	\CBuser::getUserDataInstance( (int) $mailToEmail );

							if ( ! $mailToUser->getInt( 'id', 0 ) ) {
								continue;
							}

							$mailTo[$k]					=	$mailToUser->getString( 'email', '' );

							if ( ! $mailToLanguage ) {
								$mailToLanguage			=	$mailToUser->getUserLanguage();
							}
						}
					}

					if ( \count( $mailTo ) > 1 ) {
						// Too many recipients to determine accurate language so lets just use the triggering users language:
						$mailToLanguage					=	null;
					}
				}
			}

			if ( ! $mailTo ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_EMAIL_NO_TO', ':: Action [action] :: Email skipped due to missing to', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$savedLanguage								=	null;

			if ( $mailToLanguage ) {
				$savedLanguage							=	CBTxt::setLanguage( $mailToLanguage );
			}

			$mailSubject								=	$this->string( $user, $row->getString( 'subject', '' ) );

			if ( ! $mailSubject ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_EMAIL_NO_SBJ', ':: Action [action] :: Email skipped due to missing subject', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$mailBody									=	$this->string( $user, $row->getRaw( 'body', '' ), false );

			if ( ! $mailBody ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_EMAIL_NO_BODY', ':: Action [action] :: Email skipped due to missing body', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$mailHtml									=	$row->getInt( 'mode' );
			$mailCC										=	$this->string( $user, $row->getString( 'cc', '' ) );
			$mailBCC									=	$this->string( $user, $row->getString( 'bcc', '' ) );
			$mailAttachments							=	$this->string( $user, $row->getString( 'attachment', '' ) );
			$mailReplyToEmail							=	$this->string( $user, $row->getString( 'replyto_address', '' ) );
			$mailReplyToName							=	$this->string( $user, $row->getString( 'replyto_name', '' ) );
			$mailFromEmail								=	$this->string( $user, $row->getString( 'from_address', '' ) );
			$mailFromName								=	$this->string( $user, $row->getString( 'from_name', '' ) );
			$mailMailer									=	$row->getString( 'mailer', '' );
			$mailProperties								=	[];

			if ( $savedLanguage ) {
				CBTxt::setLanguage( $savedLanguage );
			}

			if ( $mailCC ) {
				$mailCC									=	preg_split( '/ *, */', $mailCC );

				foreach ( $mailCC as $k => $mailCCEmail ) {
					if ( is_numeric( $mailCCEmail ) ) {
						$mailCC[$k]						=	\CBuser::getUserDataInstance( (int) $mailCCEmail )->getString( 'email', '' );
					}
				}
			} else {
				$mailCC									=	null;
			}

			if ( $mailBCC ) {
				$mailBCC								=	preg_split( '/ *, */', $mailBCC );

				foreach ( $mailBCC as $k => $mailBCCEmail ) {
					if ( is_numeric( $mailBCCEmail ) ) {
						$mailBCC[$k]					=	\CBuser::getUserDataInstance( (int) $mailBCCEmail )->getString( 'email', '' );
					}
				}
			} else {
				$mailBCC								=	null;
			}

			if ( $mailAttachments ) {
				$mailAttachments						=	preg_split( '/ *, */', $mailAttachments );
			} else {
				$mailAttachments						=	null;
			}

			if ( $mailReplyToEmail ) {
				$mailReplyToEmail						=	preg_split( '/ *, */', $mailReplyToEmail );
			} else {
				$mailReplyToEmail						=	null;
			}

			if ( $mailReplyToName ) {
				$mailReplyToName						=	preg_split( '/ *, */', $mailReplyToName );
			} else {
				$mailReplyToName						=	null;
			}

			if ( $mailMailer ) {
				$mailProperties['Mailer']				=	$mailMailer;

				if ( $mailMailer === 'smtp' ) {
					$mailProperties['SMTPAuth']			=	$row->getInt( 'mailer_smtpauth', 0 );
					$mailProperties['Username']			=	$row->getString( 'mailer_smtpuser', '' );
					$mailProperties['Password']			=	$row->getString( 'mailer_smtppass', '' );
					$mailProperties['Host']				=	$row->getString( 'mailer_smtphost', '' );

					$smtpPort							=	$row->getInt( 'mailer_smtpport', 0 );

					if ( $smtpPort ) {
						$mailProperties['Port']			=	$smtpPort;
					}

					$smtpSecure							=	$row->getString( 'mailer_smtpsecure', '' );

					if ( ( $smtpSecure === 'ssl' ) || ( $smtpSecure === 'tls' ) ) {
						$mailProperties['SMTPSecure']	=	$smtpSecure;
					}
				} elseif ( $mailMailer === 'sendmail' ) {
					$sendMail							=	$row->getString( 'mailer_sendmail', '' );

					if ( $sendMail ) {
						$mailProperties['Sendmail']		=	$sendMail;
					}
				}
			}

			$error										=	null;

			if ( ! comprofilerMail( $mailFromEmail, $mailFromName, $mailTo, $mailSubject, $mailBody, $mailHtml, $mailCC, $mailBCC, $mailAttachments, $mailReplyToEmail, $mailReplyToName, $mailProperties, $error ) ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_EMAIL_FAILED', ':: Action [action] :: Email failed to send. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $error ] ) );
			}
		}
	}
}