<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

if (!$canComment)
{
    return;
}

if ($captchaInvalid)
{
    $style = '';
}
else
{
    $style = ' style="display:none;"';
}

if ($config->enable_attachment)
{
	echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
}

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<tr id="tr_message_id" <?php echo $style; ?>>
    <td>
        <?php
        if ($config->use_html_editor)
        {
            echo $editor->display( 'message',  $message, '100%', '250', '75', '10' );
        }
        else
        {
        ?>
            <textarea rows="10" class="hdp_fullwidth form-control" cols="75" class="hdp_fullwidth" name="message" id="message"><?php echo $message; ?></textarea>
        <?php
        }
        if ($config->enable_attachment)
        {
        ?>
            <div class="clearfix"></div>
            <table width="100%">
                <tr>
                    <th><?php echo Text::_('HDP_ATTACHMENTS'); ?></th>
                </tr>
                <tr>
                    <td>
                        <div id="hdp_ticket_attachments" class="dropzone needsclick dz-clickable">

                        </div>
                    </td>
                </tr>
            </table>
            <?php
        }
        if ($config->enable_captcha && !empty($captcha))
        {
        ?>
            <table>
                <tr>
                    <td class="title_cell">
                        <?php echo Text::_('HDP_CAPTCHA'); ?><span class="required">*</span>
                    </td>
                    <td>
                        <?php echo $captcha; ?>
                    </td>
                </tr>
            </table>
            <?php
        }
        ?>
        <div class="clearfix"></div>
        <input type="button" name="btnSubmit" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_SUBMIT_COMMENT'); ?>" onclick="addComment(this.form);" />
        <input type="button" name="btnSubmit" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_COMMENT_AND_CLOSE'); ?>" onclick="addCommentAndClose(this.form);" />
    </td>
</tr>
