<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined( '_JEXEC' ) or die ;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

$ordering = $this->state->filter_order == 'tbl.ordering';

HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', array('placement' => 'top'));
$cols = 4;

$centerClass = $this->bootstrapHelper->getClassMapping('center');
$pullLeft    = $this->bootstrapHelper->getClassMapping('pull-left');
?>
<div id="hdp_container" class="container-fluid">
    <h1 class="hdp_title"><?php echo $this->params->get('page_heading') ?: Text::_('HDP_MY_TICKETS'); ?>
        <span class="newticket_link"><a href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.add&Itemid='.$this->Itemid); ?>"><i class="icon-new"></i><?php echo Text::_('HDP_SUBMIT_TICKET'); ?></a></span>
    </h1>
    <form action="<?php echo Route::_(RouteHelper::getTicketsRoute()); ?>" method="post" name="adminForm" id="adminForm">
        <fieldset class="filters btn-toolbar <?php echo $this->bootstrapHelper->getClassMapping('clearfix'); ?>">
            <div class="filter-search btn-group <?php echo $pullLeft; ?>>">
                <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->lists['search']); ?>" class="hasTooltip" title="<?php echo HTMLHelper::tooltipText('HDP_FILTER_SEARCH_TICKETS_DESC'); ?>" />
            </div>
            <div class="btn-group <?php echo $this->bootstrapHelper->getClassMapping('pull-left'); ?>">
                <button type="submit" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span class="<?php echo $this->bootstrapHelper->getClassMapping('icon-search'); ?>"></span></button>
                <button type="button" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><span class="<?php echo $this->bootstrapHelper->getClassMapping('icon-remove'); ?>"></span></button>
            </div>
            <div class="btn-group <?php echo $pullLeft; ?>">
				<?php
				echo $this->lists['filter_category_id'];

				if (isset($this->lists['filter_status_id']))
				{
					echo $this->lists['filter_status_id'];
				}

				if (isset($this->lists['filter_priority_id']))
				{
					echo $this->lists['filter_priority_id'];
				}

				if (isset($this->lists['filter_staff_id']))
				{
					echo $this->lists['filter_staff_id'];
				}
				?>
            </div>
        </fieldset>
        <table class="<?php echo $this->bootstrapHelper->getClassMapping('table table-striped table-bordered'); ?> table-hover">
            <thead>
            <tr>
                <th style="text-align: left;">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_TITLE'), 'tbl.subject', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
				<?php
					foreach ($this->fields as $field)
					{
					    $cols++;

					?>
                        <th>
	                        <?php
	                        if ($field->is_searchable)
	                        {
		                        echo HTMLHelper::_('grid.sort', Text::_($field->title), 'tbl.' . $field->name, $this->state->filter_order_Dir, $this->state->filter_order);
	                        }
	                        else
	                        {
		                        echo $field->title;
	                        }
	                        ?>
                        </th>
					<?php
					}
				?>
                <th class="<?php echo $centerClass; ?>">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_CREATED_DATE'), 'tbl.created_date', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
                <th class="<?php echo $centerClass; ?>">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_MODIFIED_DATE'), 'tbl.modified_date', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
                <?php
                if (isset($this->lists['filter_status_id']))
                {
                    $cols++;
                ?>
                    <th width="8%">
                        <?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_STATUS'), 'tbl.status_id', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                    </th>
                <?php
                }

                if (isset($this->lists['filter_priority_id']))
                {
                    $cols++;
                ?>
                    <th width="8%">
                        <?php echo HTMLHelper::_('grid.sort', Text::_('HDP_PRIORITY'), 'tbl.priority_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                    </th>
                <?php
                }

                if (!empty($this->showStaffColumn))
				{
					$cols++;
				?>
                    <th width="10%">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_ASSIGNED_TO'), 'tbl.staff_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                    </th>
				<?php
				}
				?>
                <th width="2%" class="<?php echo $centerClass; ?>">
					<?php echo HTMLHelper::_('grid.sort',  Text::_('HDP_ID'), 'tbl.id', $this->state->filter_order_Dir, $this->state->filter_order ); ?>
                </th>
            </tr>
            </thead>
            <tfoot>
            <tr>
                <td colspan="<?php echo $cols + count($this->fields); ?>">
                    <div class="pagination"><?php echo $this->pagination->getListFooter(); ?></div>
                </td>
            </tr>
            </tfoot>
            <tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $this->items ); $i < $n; $i++)
			{
				$row = $this->items[$i];
				$link 	= Route::_(RouteHelper::getTicketRoute($row->id), false);
				?>
                <tr class="<?php echo "row$k"; ?> hdp-ticket-status-<?php echo $row->status_id; ?>">
                    <td>
                        <a href="<?php echo $link; ?>"><?php echo $this->escape($row->subject) ; ?></a>	<br />
                        <small><?php echo Text::_('HDP_CATEGORY'); ?>: <strong><?php echo $row->category_title ; ?></strong></small>
                    </td>
					<?php
					if(count($this->fields))
					{
						foreach ($this->fields as $field)
						{
						?>
                            <td>
								<?php echo isset($this->fieldValues[$row->id][$field->id]) ? $this->fieldValues[$row->id][$field->id] : '';?>
                            </td>
						<?php
						}
					}
					?>
                    <td class="<?php echo $centerClass; ?>">
						<?php echo HTMLHelper::_('date', $row->created_date, $this->config->date_format); ?>
                    </td>
                    <td class="<?php echo $centerClass; ?>">
						<?php echo HTMLHelper::_('date', $row->modified_date, $this->config->date_format); ?>
                    </td>
                    <?php
                        if (isset($this->lists['filter_status_id']))
                        {
                        ?>
                            <td>
		                        <?php echo @$this->statusList[$row->status_id]; ?>
                            </td>
                        <?php
                        }

                        if (isset($this->lists['filter_priority_id']))
                        {
                        ?>
                            <td>
		                        <?php echo @$this->priorityList[$row->priority_id]; ?>
                            </td>
                        <?php
                        }

                        if (!empty($this->showStaffColumn))
                        {
                        ?>
                            <td>
                                <?php echo $this->staffs[$row->staff_id]; ?>
                            </td>
                        <?php
                        }
					?>
                    <td class="<?php echo $centerClass; ?>">
						<?php echo $row->id; ?>
                    </td>
                </tr>
				<?php
				$k = 1 - $k;
			}
			?>
            </tbody>
        </table>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="filter_order" value="<?php echo $this->state->filter_order; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $this->state->filter_order_Dir; ?>" />
		<?php echo HTMLHelper::_( 'form.token' ); ?>
    </form>
</div>