<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

HTMLHelper::_('behavior.core');
HTMLHelper::_('behavior.keepalive');

$document = Factory::getDocument();
$rootUri = Uri::root();

$editor = Editor::getInstance(Factory::getConfig()->get('editor'));

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/jquery.selection.js');
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js');
}

$document->addScript($rootUri . '/media/com_helpdeskpro/js/site-ticket-form.js');

/* @var HelpdeskproViewTicketHtml $this */
$role = HelpdeskproHelper::getUserRole($this->userId);

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$rowFluidClass       = $bootstrapHelper->getClassMapping('row-fluid');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<div class="container-fluid">
<h1 class="hdp_title title"><?php echo $this->params->get('page_heading') ?: Text::_('HDP_NEW_TICKET'); ?></h1>
<form class="<?php echo $formHorizontalClass; ?>" name="hdp_form" id="hdp_form" action="<?php echo Route::_('index.php?option=com_helpdeskpro&Itemid='.$this->Itemid); ?>" method="post" enctype="multipart/form-data">
<?php
	if (!$this->userId)
	{
	?>
		<div class="<?php echo $controlGroupClass; ?>">
			<label class="<?php echo $controlLabelClass; ?>" for="name"><?php echo Text::_('HDP_NAME'); ?><span class="required">*</span></label>
			<div class="<?php echo $controlsClass; ?>">
      			<input type="text" id="name" name="name" class="input-xlarge form-control validate[required]" value="<?php echo $this->escape($this->input->getString('name')); ?>" />
    		</div>			
		</div>
		<div class="<?php echo $controlGroupClass; ?>">
			<label class="<?php echo $controlLabelClass; ?>" for="email"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></label>
			<div class="<?php echo $controlsClass; ?>">
      			<input type="text" id="email" name="email" class="input-xlarge form-control validate[required,custom[email]]" value="<?php echo $this->escape($this->input->getString('email')); ?>" />
    		</div>			
		</div>
	<?php	
	}

	if (count($this->rowCategories) > 1)
    {
    ?>
        <div class="<?php echo $controlGroupClass; ?>">
            <label class="<?php echo $controlLabelClass; ?>" for="category_id"><?php echo Text::_('HDP_CATEGORY'); ?><span class="required">*</span></label>
            <div class="<?php echo $controlsClass; ?>">
			    <?php echo $this->lists['category_id'] ; ?>
            </div>
        </div>
    <?php
    }
?>
	<div class="<?php echo $controlGroupClass; ?>">
			<label class="<?php echo $controlLabelClass; ?>" for="subject"><?php echo Text::_('HDP_SUBJECT'); ?><span class="required">*</span></label>
			<div class="<?php echo $controlsClass; ?>">
      			   <input type="text" id="subject" name="subject" class="input-xlarge form-control validate[required]" value="<?php echo $this->escape($this->input->getString('subject')); ?>" size="50" />
    		</div>			
	</div>
	<?php
		if (isset($this->lists['priority_id']))
		{
		?>
			<div class="<?php echo $controlGroupClass; ?>">
				<label class="<?php echo $controlLabelClass; ?>" for="priority_id"><?php echo Text::_('HDP_PRIORITY'); ?><span class="required">*</span></label>
				<div class="<?php echo $controlsClass; ?>">
					<?php echo $this->lists['priority_id'] ; ?>
				</div>
			</div>
		<?php
		}

		$fields = $this->form->getFields();

		/* @var HDPFormField $field*/
		foreach ($fields as $field)
		{
			echo $field->getControlGroup(true, $this->bootstrapHelper);
		}
	?>
	<div class="<?php echo $controlGroupClass; ?>">
			<label class="<?php echo $controlLabelClass; ?>" for="message"><?php echo Text::_('HDP_MESSAGE'); ?><span class="required">*</span></label>
			<div class="<?php echo $controlsClass; ?>">
				<?php 
					if ($this->config->use_html_editor)
					{						
						echo $editor->display( 'message',  $this->input->getHtml('message'), '100%', '250', '75', '10' );
					}
					else 
					{
					?>
						<textarea rows="10" cols="70" class="hdp_fullwidth form-control validate[required]" name="message" id="message"><?php echo $this->escape($this->input->getString('message')); ?></textarea>
					<?php	
					}
				?>										   			    
    		</div>						
	</div>

	<?php
	    if ($this->config->enable_attachment)
		{
		?>
			<div class="<?php echo $controlGroupClass; ?>">
				<label class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_ATTACHMENTS'); ?></label>
				<div class="<?php echo $controlsClass; ?>">
                    <div id="hdp_ticket_attachments" class="dropzone needsclick dz-clickable">

                    </div>
	    		</div>						
			</div>	
		<?php	
		}
		if ($this->showCaptcha)
		{
		?>			
			<div class="<?php echo $controlGroupClass; ?>">
				<label class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_CAPTCHA'); ?><span class="required">*</span></label>
				<div class="<?php echo $controlsClass; ?>">
					<?php echo $this->captcha; ?>			
				</div>
			</div>	
		<?php							
		}
	?>	
	<div class="form-actions">
		<input type="button" name="btnSubmit" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_CANCEL'); ?>" onclick="HDP.ticketList();" />
		<input type="submit" name="btnSubmit" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_SUBMIT_TICKET'); ?>" />
	</div>
    <?php
        if ($this->config->enable_attachment)
        {
	        echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
        }
    ?>
	<input type="hidden" name="option" value="com_helpdeskpro" />
	<input type="hidden" name="task" value="ticket.save" />
	<input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>" />
    <?php
        if (count($this->rowCategories) == 1)
        {
            $categoryId = $this->rowCategories[0]->id;
        ?>
            <input type="hidden" name="category_id" value="<?php echo $categoryId; ?>" />
        <?php
        }
    ?>

	<?php echo HTMLHelper::_( 'form.token' ); ?>
</form>	
</div>