<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Categories;

use HelpdeskProHelperBootstrap;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

defined('_JEXEC') or die;

class Html extends ListView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		foreach ($this->items as $item)
		{
			RouteHelper::addArticles($item->articles);
		}

		// Handle page title
		$active = $this->container->app->getMenu()->getActive();
		$params = HelpdeskproHelperHtml::getViewParams($active, array('categories'));
		HelpdeskproHelperHtml::prepareDocument($params);

		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
	}
}